\name{pascal_classification_pfo}
\alias{pascal_classification_pfo}
\title{
PFO-Associated Stroke Causal Likelihood (PASCAL) Classification
}
\description{
Calculates the PASCAL classification to estimate the causal likelihood of a Patent Foramen Ovale (PFO) in a patient with cryptogenic stroke. This system integrates the RoPE Score with high-risk PFO anatomical features (large shunt or atrial septal aneurysm) to categorize the stroke-PFO relationship as Unlikely, Possible, or Probable.
}
\usage{
pascal_classification_pfo(rope_score, high_risk_pfo_features)
}
\arguments{
  \item{rope_score}{
Numeric. The Risk of Paradoxical Embolism (RoPE) score (0-10).
}
  \item{high_risk_pfo_features}{
Numeric (0 or 1). Presence of high-risk PFO features, defined as a large shunt or an atrial septal aneurysm (ASA). (1 = Yes).
}
}
\value{
A list containing:
\item{PASCAL_Classification}{The causal likelihood category (Unlikely, Possible, Probable).}
}
\references{
Kent DM, Saver JL, Kasner SE, et al. Heterogeneity of Treatment Effects in an Analysis of Pooled Individual Patient Data From Randomized Trials of Device Closure of Patent Foramen Ovale After Stroke. JAMA. 2021;326(22):2277–2286. doi:10.1001/jama.2021.20956
}
\examples{
# Example 1: Probable (High RoPE + High Risk PFO)
pascal_classification_pfo(8, 1)

# Example 2: Possible (Low RoPE + High Risk PFO)
pascal_classification_pfo(4, 1)

# Example 3: Unlikely (Low RoPE + No High Risk Features)
pascal_classification_pfo(3, 0)
}
