\name{gold_copd_criteria}
\alias{gold_copd_criteria}
\title{
GOLD Criteria for COPD (ABCD Assessment Tool)
}
\description{
Calculates the GOLD Grade (1-4) based on airflow limitation and the GOLD Group (A, B, C, D) based on symptom burden and exacerbation risk. This combined assessment guides initial pharmacological treatment.
}
\usage{
gold_copd_criteria(fev1_percent_predicted, exacerbations_last_year,
                   hospitalized_for_exacerbation, mmrc_score = NULL,
                   cat_score = NULL)
}
\arguments{
  \item{fev1_percent_predicted}{
Numeric. Post-bronchodilator FEV1 percent predicted. Used for spirometric grading (GOLD 1-4).
}
  \item{exacerbations_last_year}{
Numeric. Number of moderate exacerbations in the past year (requiring antibiotics and/or oral steroids).
}
  \item{hospitalized_for_exacerbation}{
Numeric (0 or 1). Has the patient had >= 1 exacerbation leading to hospitalization? (1 = Yes).
}
  \item{mmrc_score}{
Numeric (0-4) (Optional). Modified Medical Research Council Dyspnea Scale.
}
  \item{cat_score}{
Numeric (0-40) (Optional). COPD Assessment Test score.
}
}
\details{
\strong{Risk Assessment (Y-Axis):}
Low Risk: 0 or 1 moderate exacerbation (not leading to admission).
High Risk: >= 2 moderate exacerbations OR >= 1 leading to admission.

\strong{Symptom Assessment (X-Axis):}
Low Symptoms: mMRC 0-1 OR CAT < 10.
High Symptoms: mMRC >= 2 OR CAT >= 10.
}
\value{
A list containing:
\item{GOLD_Spirometry_Grade}{Classification of airflow limitation (GOLD 1-4).}
\item{GOLD_Group}{ABCD grouping based on symptoms and risk.}
\item{Treatment_Recommendation}{Initial pharmacological management guidance.}
}
\references{
Global Initiative for Chronic Obstructive Lung Disease (GOLD). Global Strategy for the Diagnosis, Management, and Prevention of Chronic Obstructive Lung Disease. 2020 Report.
}
\examples{

# Example 1: Group B (High Symptom, Low Risk)
# FEV1 60\% (GOLD 2), 0 Exacerbations, mMRC 2
gold_copd_criteria(60, 0, 0, mmrc_score = 2)

# Example 2: Group D (High Symptom, High Risk)
# FEV1 35\% (GOLD 3), 2 Exacerbations, CAT 18
gold_copd_criteria(35, 2, 0, cat_score = 18)
}
