\name{dire_opioid_score}
\alias{dire_opioid_score}
\title{
DIRE Score for Opioid Treatment
}
\description{
Calculates the DIRE Score (Diagnosis, Intractability, Risk, Efficacy) to predict the efficacy and compliance of long-term opioid analgesic treatment for non-cancer pain. The score evaluates 7 factors, each rated on a scale of 1 to 3.
}
\usage{
dire_opioid_score(diagnosis, intractability, risk_psychological, risk_chemical,
                  risk_reliability, risk_social, efficacy)
}
\arguments{
  \item{diagnosis}{
Numeric (1-3).
1: Benign condition with minimal objective findings.
2: Slowly progressive condition with moderate objective findings.
3: Advanced condition with clear objective findings.
}
  \item{intractability}{
Numeric (1-3).
1: Few therapies tried, patient passive.
2: Most therapies tried, limited response.
3: Fully engaged, multiple therapies failed.
}
  \item{risk_psychological}{
Numeric (1-3).
1: Severe personality disorder or mental illness.
2: Moderate or treated mental illness.
3: Good psychological stability.
}
  \item{risk_chemical}{
Numeric (1-3).
1: Active or recent addiction.
2: History of addiction in remission.
3: No history of chemical dependency.
}
  \item{risk_reliability}{
Numeric (1-3).
1: History of medication misuse, missed appointments.
2: Occasional difficulties with compliance.
3: Highly reliable, compliant with care.
}
  \item{risk_social}{
Numeric (1-3).
1: Chaotic life, poor support.
2: Moderate support.
3: Supportive family/friends, stable life.
}
  \item{efficacy}{
Numeric (1-3).
1: Poor function or minimal pain relief with opioids.
2: Moderate benefit.
3: Good improvement in function and pain.
}
}
\value{
A list containing:
\item{DIRE_Score}{The calculated total score (Range 7-21).}
\item{Suitability}{Interpretation of the score (Suitable >= 14, Not Suitable <= 13).}
}
\references{
Belgrade MJ, Schamber CD, Lindgren BR. The DIRE score: predicting outcomes of opioid prescribing for chronic pain. J Pain. 2006;7(9):671-681. doi:10.1016/j.jpain.2006.03.001
}
\examples{

# Example 1: Poor Candidate
# All items scored 1
dire_opioid_score(1, 1, 1, 1, 1, 1, 1)

# Example 2: Good Candidate
# All items scored 3
dire_opioid_score(3, 3, 3, 3, 3, 3, 3)
}
