\name{clif_c_aclf_score}
\alias{clif_c_aclf_score}
\title{
CLIF-C ACLF Score for Acute-on-Chronic Liver Failure
}
\description{
Calculates the CLIF-C ACLF (Consortium on Chronic Liver Failure - Acute-on-Chronic Liver Failure) score. This prognostic score is specifically designed for patients with ACLF (Acute-on-Chronic Liver Failure) to predict 28-day and 90-day mortality. It incorporates the CLIF-OF (Organ Failure) score, Age, and White Blood Cell count.
}
\usage{
clif_c_aclf_score(age, wbc_count, bilirubin, creatinine, inr, map,
                  use_vasopressors, pao2_fio2_ratio, he_grade,
                  bilirubin_units = "mg/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{wbc_count}{
Numeric. White Blood Cell count in x10^9/L.
}
  \item{bilirubin}{
Numeric. Total Bilirubin level.
}
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{map}{
Numeric. Mean Arterial Pressure in mmHg.
}
  \item{use_vasopressors}{
Numeric (0 or 1). Is the patient on vasopressors? (1 = Yes).
}
  \item{pao2_fio2_ratio}{
Numeric. PaO2/FiO2 ratio.
}
  \item{he_grade}{
Numeric (0-4). West Haven Grade of Hepatic Encephalopathy.
}
  \item{bilirubin_units}{
String. Units for bilirubin. "mg/dL" (default) or "umol/L".
}
  \item{creatinine_units}{
String. Units for creatinine. "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{CLIF_C_ACLF_Score}{The calculated prognostic score.}
\item{CLIF_OF_Score}{The intermediate Organ Failure score (Sum of 6 organ system scores).}
\item{Est_28_Day_Mortality}{Estimated 28-day mortality probability.}
\item{Est_90_Day_Mortality}{Estimated 90-day mortality probability.}
}
\references{
Jalan R, Saliba F, Pavesi M, et al. Development and validation of a prognostic score to predict mortality in patients with acute-on-chronic liver failure. J Hepatol. 2014;61(5):1038-1047. doi:10.1016/j.jhep.2014.06.012
}
\examples{

# Example 1: High Mortality
# Age 60, WBC 15, Bili 15, Cr 4.0, INR 3.0, Pressors Yes, PF 150, HE Grade 3
clif_c_aclf_score(60, 15, 15, 4.0, 3.0, 60, 1, 150, 3)

# Example 2: Lower Mortality
# Age 45, WBC 8, Bili 5, Cr 1.5, INR 1.5, MAP 80, No Pressors, PF 350, HE Grade 1
clif_c_aclf_score(45, 8, 5, 1.5, 1.5, 80, 0, 350, 1)
}
