\name{carg_chemo_toxicity_score}
\alias{carg_chemo_toxicity_score}
\title{
Cancer and Aging Research Group (CARG) Chemotherapy Toxicity Tool
}
\description{
Calculates the CARG Toxicity Score to predict the risk of Grade 3-5 chemotherapy toxicity in older adults (age >= 65) with cancer. This tool outperforms Karnofsky Performance Status (KPS) in this population by incorporating geriatric assessment variables such as functional status, comorbidities, and social support.
}
\usage{
carg_chemo_toxicity_score(age, sex, weight_kg, height_cm, creatinine_mg_dl,
                          hemoglobin_g_dl, cancer_type_gi_gu, standard_dose,
                          polychemotherapy, falls_last_6mo, hearing_impairment,
                          limit_walking_1block, assistance_meds,
                          limit_social_activity)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 72 adds 2 points).
}
  \item{sex}{
String. "male" or "female". Used for Jelliffe CrCl calculation and anemia thresholds.
}
  \item{weight_kg}{
Numeric. Patient weight in kg (Not strictly used in simplified Jelliffe but required for general context).
}
  \item{height_cm}{
Numeric. Patient height in cm.
}
  \item{creatinine_mg_dl}{
Numeric. Serum creatinine in mg/dL. Used to calculate Creatinine Clearance via Jelliffe formula (1973). (< 34 mL/min adds 3 points).
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin in g/dL. Anemia (<11 for males, <10 for females) adds 3 points.
}
  \item{cancer_type_gi_gu}{
Numeric (0 or 1). Is the cancer Gastrointestinal or Genitourinary? (1 = Yes, +2 points).
}
  \item{standard_dose}{
Numeric (0 or 1). Is the patient receiving standard dose chemotherapy (vs. dose-reduced)? (1 = Yes, +2 points).
}
  \item{polychemotherapy}{
Numeric (0 or 1). Is the patient receiving more than one chemotherapy drug? (1 = Yes, +2 points).
}
  \item{falls_last_6mo}{
Numeric (0 or 1). Has the patient fallen in the last 6 months? (1 = Yes, +3 points).
}
  \item{hearing_impairment}{
Numeric (0 or 1). Is hearing "Fair" or "Worse" (or deaf)? (1 = Yes, +2 points).
}
  \item{limit_walking_1block}{
Numeric (0 or 1). Does the patient have any trouble walking one block? (1 = Yes, +2 points).
}
  \item{assistance_meds}{
Numeric (0 or 1). Does the patient need help taking medications? (1 = Yes, +1 point).
}
  \item{limit_social_activity}{
Numeric (0 or 1). Has physical or emotional health limited social activities? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{CARG_Score}{The total calculated score (Range 0-23).}
\item{Risk_Level}{Risk stratum (Low, Intermediate, High).}
\item{Grade_3_5_Toxicity_Risk}{Estimated percentage probability of severe toxicity.}
\item{Calculated_Jelliffe_CrCl}{The calculated CrCl value used in scoring.}
}
\references{
Hurria A, Togawa K, Mohile SG, et al. Predicting chemotherapy toxicity in older adults with cancer: a prospective multicenter study. J Clin Oncol. 2011;29(25):3457-3465. doi:10.1200/JCO.2011.34.7625
}
\examples{

# Example 1: High Risk
# 75yo Male, GI Cancer, Standard Dose, Anemic, Fall Hx
# Score calculation depends on CrCl and other factors
carg_chemo_toxicity_score(75, "male", 70, 175, 1.2, 10.0, 1, 1, 0, 1, 0, 0, 0, 0)

# Example 2: Low Risk
# 66yo Female, Breast Cancer (Other), Reduced Dose, No functional deficits
carg_chemo_toxicity_score(66, "female", 60, 160, 0.8, 12.0, 0, 0, 1, 0, 0, 0, 0, 0)
}
