\name{calculate_plasma_dosage}
\alias{calculate_plasma_dosage}
\title{
Plasma Dosage Calculator
}
\description{
Calculates the total volume of Fresh Frozen Plasma (FFP) required based on patient weight and a specified dose per kilogram. Standard dosing for reversal of coagulopathy (e.g., warfarin reversal or elevated INR) typically ranges from 10 to 15 mL/kg, though 15 mL/kg is a common starting point.
}
\usage{
calculate_plasma_dosage(weight_kg, dose_per_kg_ml = 15)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{dose_per_kg_ml}{
Numeric. The desired dose of plasma in mL/kg. Defaults to 15 mL/kg, which is generally recommended for INR reversal. Ranges often cited are 10-20 mL/kg.
}
}
\details{
The calculation is simply:
\deqn{Total Volume (mL) = Weight (kg) \times Dose (mL/kg)}
The number of units is estimated assuming an average volume of 200-250 mL per unit of FFP.
}
\value{
A list containing:
\item{Total_Plasma_Volume_mL}{The calculated total volume of plasma in milliliters.}
\item{Estimated_Units_FFP}{An estimated range of FFP units required.}
}
\references{
Practice Guidelines for Blood Component Therapy: A Report by the American Society of Anesthesiologists Task Force on Blood Component Therapy. Anesthesiology. 1996;84(3):732-747.
Holland LL, Brooks JP. Toward rational fresh frozen plasma transfusion: The effect of plasma transfusion on coagulation test results. Am J Clin Pathol. 2006;126(1):133-139.
}
\examples{

# Example 1: 70kg patient, standard 15 mL/kg dose
# Volume = 70 * 15 = 1050 mL (~4-5 units)
calculate_plasma_dosage(70, 15)

# Example 2: 50kg patient, 10 mL/kg dose
# Volume = 50 * 10 = 500 mL (~2-2.5 units)
calculate_plasma_dosage(50, 10)
}
