\name{abc_massive_transfusion}
\alias{abc_massive_transfusion}
\title{
Assessment of Blood Consumption (ABC) Score for Massive Transfusion
}
\description{
Calculates the ABC Score to predict the need for massive transfusion in adult trauma patients. The score uses four non-laboratory variables available early in the trauma resuscitation to identify patients who may benefit from activation of a Massive Transfusion Protocol (MTP).
}
\usage{
abc_massive_transfusion(penetrating_mechanism, positive_fast, sbp_mmHg, hr_bpm)
}
\arguments{
  \item{penetrating_mechanism}{
Numeric (0 or 1). Was the mechanism of injury penetrating? 1 = Yes, 0 = No.
}
  \item{positive_fast}{
Numeric (0 or 1). Was the Focused Assessment with Sonography for Trauma (FAST) positive? 1 = Yes, 0 = No.
}
  \item{sbp_mmHg}{
Numeric. Arrival Systolic Blood Pressure in mmHg. (1 point is added if SBP <= 90).
}
  \item{hr_bpm}{
Numeric. Arrival Heart Rate in beats per minute. (1 point is added if HR >= 120).
}
}
\value{
A list containing:
\item{Total_Score}{The sum of risk factors present (Range 0-4).}
\item{Interpretation}{Clinical interpretation indicating likelihood of needing massive transfusion (Score >= 2 suggests MTP activation).}
}
\references{
Nunez TC, Voskresensky IV, Dossett LA, et al. Early prediction of massive transfusion in trauma: simple as ABC (assessment of blood consumption)? J Trauma. 2009;66(2):346-352. doi:10.1097/TA.0b013e3181961c35
}
\examples{

# Example 1: MTP Likely
# Penetrating trauma, Positive FAST, Hypotensive, Tachycardic
abc_massive_transfusion(1, 1, 85, 130)

# Example 2: MTP Unlikely
# Blunt trauma, Negative FAST, Stable vitals
abc_massive_transfusion(0, 0, 110, 88)
}
