% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_wpc.R
\name{return_to_scale}
\alias{return_to_scale}
\title{Extract the return to scale parameter used to compute this model}
\usage{
return_to_scale(sim, ...)
}
\arguments{
\item{sim}{a spatial interaction model with a return to scale parameter}

\item{...}{additional parameters}
}
\value{
the return to scale parameter
}
\description{
Extract the return to scale parameter used to compute this model
}
\examples{
positions <- matrix(rnorm(10 * 2), ncol = 2)
distances <- as.matrix(dist(positions))
production <- rep(1, 10)
attractiveness <- c(2, rep(1, 9))
model <- static_blvim(distances, production, 1.5, 1, attractiveness)
return_to_scale(model) ## should be 1.5
}
