% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_tree.R
\name{build_nj_tree}
\alias{build_nj_tree}
\title{Build a Neighbor-Joining tree from a multiple sequence alignment}
\usage{
build_nj_tree(msa, model = "raw", pairwise.deletion = TRUE)
}
\arguments{
\item{msa}{A multiple alignment object (class \code{MsaDNAMultipleAlignment} or similar)}

\item{model}{Evolutionary model for distance calculation passed to \code{ape::dist.dna}
(e.g., "raw", "JC69", "K80", etc.)}

\item{pairwise.deletion}{Logical. If TRUE, compute distances with pairwise deletion}
}
\value{
An object of class \code{phylo} (NJ tree)
}
\description{
This function takes a Multiple Sequence Alignment (MSA) object (e.g., output of
\code{align_sequences(method = "msa")}) and generates a Neighbor-Joining (NJ) tree.
}
\examples{
\donttest{
# Build NJ tree from multiple sequence alignment (requires msa package)
if (requireNamespace("msa", quietly = TRUE)) {
  # Create example sequences
  df <- data.frame(
    accession = c("seq1", "seq2", "seq3"),
    sequence = c("ATGCATGC", "ATGCTAGC", "ATGGATGC")
  )
  
  # Generate MSA
  msa_result <- align_sequences(df, method = "msa", msa_method = "ClustalOmega")
  
  # Build NJ tree
  tree <- build_nj_tree(msa_result, model = "raw")
  print(tree)
}
}
}
