% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_audit_report.R
\name{generate_audit_report}
\alias{generate_audit_report}
\title{Generate Automated Data Quality Audit Report}
\usage{
generate_audit_report(
  data,
  filename = "dq_audit_report",
  output_dir = NULL,
  output_format = "pdf",
  method = "iforest",
  contamination = 0.05,
  top_n = 100,
  id_cols = NULL,
  exclude_cols = NULL,
  ground_truth_col = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing the data to be audited.}

\item{filename}{Character string for the output file (without extension).
Default is "dq_audit_report".}

\item{output_dir}{Character string specifying the directory for the output file.
If NULL (default), uses tempdir(). Users should specify a directory explicitly
for production use.}

\item{output_format}{Character string indicating the output format.
Options: "pdf" (default), "html", or "docx" (for editable Word document).
Note: PDF format provides the best color rendering for heat map tables.
DOCX format is generated by first creating a PDF, then converting to DOCX.}

\item{method}{Character string indicating the anomaly detection method.
Passed to \code{score_anomaly()}. Default is "iforest".}

\item{contamination}{Numeric value between 0 and 1. Passed to \code{score_anomaly()}.
Default is 0.05.}

\item{top_n}{Integer indicating the number of top anomalous records to display
in the prioritized audit listing. Default is 100.}

\item{id_cols}{Character vector of column names to exclude from scoring.
Passed to \code{prep_for_anomaly()}.}

\item{exclude_cols}{Character vector of additional columns to exclude.
Passed to \code{prep_for_anomaly()}.}

\item{ground_truth_col}{Character string naming a column with ground truth labels.
If provided, benchmarking metrics will be included in the report.}

\item{...}{Additional arguments passed to \code{score_anomaly()}.}
}
\value{
Invisibly returns the path to the generated report file.
}
\description{
Executes the complete anomaly detection pipeline (preprocessing, scoring, flagging)
and generates a professional PDF, HTML, or DOCX report with visualizations and prioritized
audit listings.
}
\examples{
\donttest{
data <- data.frame(
  patient_id = 1:50,
  age = rnorm(50, 50, 15),
  cost = rnorm(50, 10000, 5000),
  gender = sample(c("M", "F"), 50, replace = TRUE)
)
# Generate HTML report (fastest, no LaTeX/pandoc required)
generate_audit_report(data, filename = "my_audit", output_format = "html",
                       output_dir = tempdir())
}
}
