% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.group_tna_permutation}
\alias{plot.group_tna_permutation}
\title{Plot Permutation Test Results}
\usage{
\method{plot}{group_tna_permutation}(x, title, ...)
}
\arguments{
\item{x}{A \code{group_tna_permutation} object.}

\item{title}{An optional \code{character} vector of titles for each plot.
When not provided, the title shows the names of the clusters being
contrasted.}

\item{...}{Arguments passed to \code{\link[=plot.tna_permutation]{plot.tna_permutation()}}.}
}
\value{
A \code{list} (invisibly) of \code{qgraph} objects depicting the significant
difference between each pair.
}
\description{
Plot Permutation Test Results
}
\examples{
model <- group_tna(engagement_mmm)
# Small number of iterations for CRAN
perm <- permutation_test(model, iter = 20)
plot(perm)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
