test_that("SRSplineMed runs and returns expected structure", {
  data("data.sim.med")
  medModel <- SRSplineMed(data = data.sim.med, nBasis = 5,
                          exposure = "pesticide1",
                          mediator = "hormone",
                          outcome = "ySim",
                          confounderVec = c("age", "invwt", "race2", "race3", "race4", "race5",
                                            "season2", "season3", "season4", "smoking1", "ovum1",
                                            "diabetes1"),
                          shapeExp = "concave", shapeNonExp = "increasing",
                          mValue = 0.15, varAsymp = TRUE)
  expect_true(!any(is.na(medModel$CDE)))
  expect_true(!any(is.na(medModel$NDE)))
  expect_true(!any(is.na(medModel$NIE)))
})
