# ProfileLadder

[![CRAN Version](https://www.r-pkg.org/badges/version/ProfileLadder)](https://cran.r-project.org/package=ProfileLadder)
[![CRAN Downloads](https://cranlogs.r-pkg.org/badges/grand-total/ProfileLadder)](https://cran.r-project.org/package=ProfileLadder)
[![License: GPL-2](https://img.shields.io/github/v/release/42463863/ProfileLadder?style=flat-square)](https://opensource.org/licenses/GPL-2.0)

## Overview

The **R** package **ProfileLadder** provides nonparametric, functional-based methods for claims reserving based on 
aggregated chain-ladder data also known as the run-off triangles. 
The package implements three estimation/prediction algorithms (PARALLAX, REACT, and MACRAME) 
and the permutation bootstrap add-on proposed in Maciak, Mizera, and Pešta (2022). 


The package offers a flexible and computationally effective framework for point-wise and distributional 
reserve predictions and includes pertinent visualization and diagnostic tools through S3 methods.
It also provides accessor functions and real-world datasets to support exploratory analysis across insurance, 
operational risks, and other domains where triangular data structures arise, making modern, transparent, 
and extensible alternatives to classical approaches accessible in insurance industry and academic research.



## Installation

The **R** package **ProfileLadder** can be downloaded from CRAN and installed in R by using

```
install.packages("ProfileLadder")
```

