# SCCS @(#)survexp.flr.s	4.3 01/23/95
#
# Create the Florida hazards table, by race
#   The raw numbers below are q* 10^5.  Note that there are 24 leap years/100
#
survexp.flr  <- {
    temp1 <- c(
     2053,150,109,86,69,61,57,53,48,43,38,38,46,64,90,121,150,175,190,197,203,
     210,212,210,204,194,184,177,175,178,184,191,201,214,231,251,275,300,326,
     353,381,413,451,498,554,616,680,746,814,886,964,1052,1157,1284,1430,1596,
     1770,1933,2068,2181,2285,2401,2539,2704,2886,3065,3236,3416,3616,3840,
     4075,4326,4624,4989,5420,5926,6483,7060,7627,8203,8899,9771,10705,11582,
     12356,13319,14507,15829,17280,18818,20339,21871,23521,25348,27236,29014,
     30431,31784,33085,34324,35479,36553,37550,38471,39320,40101,40818,41475,
     42075,42624,1505,141,79,62,49,45,40,37,34,32,31,31,33,37,43,50,57,62,65,
     66,66,67,68,69,71,73,75,77,80,82,86,90,98,108,120,135,151,167,183,197,212,
     228,248,273,302,334,365,398,432,468,508,551,594,637,679,725,775,820,857,
     892,924,963,1019,1098,1195,1302,1412,1531,1662,1810,1970,2150,2371,2650,
     2990,3396,3860,4365,4888,5430,6057,6805,7610,8438,9293,10370,11635,12958,
     14248,15498,16766,18170,19751,21542,23440,25298,26762,28133,29413,30615,
     31742,32794,33772,34679,35517,36289,36999,37651,38248,38793,1293,116,84,
     69,54,48,45,41,35,28,22,21,31,54,83,111,136,157,174,188,203,216,224,227,
     225,221,217,213,208,204,200,196,196,200,209,221,234,250,267,285,308,335,
     364,393,423,455,494,545,609,683,761,839,919,1000,1084,1173,1266,1364,1467,
     1576,1691,1815,1948,2089,2234,2372,2515,2689,2909,3176,3474,3783,4104,
     4429,4768,5150,5588,6066,6580,7139,7795,8571,9409,10249,11071,12104,13298,
     14534,15768,17015,18318,19755,21355,23110,24897,26617,28001,29311,30545,
     31703,32784,33791,34724,35588,36384,37117,37790,38407,38971,39486,1032,97,
     74,41,30,29,24,21,18,16,14,15,20,28,38,49,57,65,69,73,76,79,81,81,80,79,
     78,78,77,77,77,78,80,83,88,95,102,112,125,140,157,177,197,214,230,248,269,
     293,321,351,382,413,446,480,516,553,592,637,688,745,808,876,944,1011,1078,
     1142,1215,1307,1428,1579,1750,1932,2125,2326,2543,2783,3063,3402,3818,
     4315,4909,5595,6341,7106,7890,8826,9919,11057,12194,13355,14626,16050,
     17558,19109,20668,22228,23729,25173,26551,27859,29094,30255,31342,32355,
     33297,34168,34973,35715,36397,37022)
    temp2 <- c(
     3636,268,178,110,94,92,85,80,76,74,73,76,87,107,136,171,208,246,283,319,
     364,415,462,495,514,527,542,554,564,574,581,589,605,634,674,721,771,831,
     900,976,1057,1140,1224,1309,1398,1494,1599,1712,1831,1953,2078,2207,2340,
     2478,2624,2771,2926,3107,3321,3562,3825,4090,4333,4529,4687,4820,4962,
     5144,5404,5752,6192,6675,7133,7457,7629,7747,7902,8044,8195,8347,8423,
     8424,8464,8622,8899,9661,10480,11341,12205,13090,14020,15072,16325,17861,
     19572,21270,21795,22278,22723,23132,23506,23848,24160,24445,24705,24941,
     25155,25350,25526,25686,3024,218,158,105,84,69,56,48,43,41,41,44,49,58,68,
     82,97,112,125,136,149,163,176,183,187,189,194,204,224,249,279,308,334,355,
     375,394,418,457,514,584,658,729,793,848,899,953,1014,1076,1135,1193,1251,
     1313,1383,1462,1552,1645,1743,1859,2001,2165,2344,2529,2708,2867,3003,
     3128,3254,3390,3558,3767,4028,4318,4608,4838,4993,5122,5274,5430,5606,
     5799,5982,6137,6277,6405,6522,6970,7529,8251,9168,10272,11539,12901,14271,
     15563,16837,18220,18719,19180,19605,19996,20355,20684,20985,21259,21510,
     21738,21945,22134,22305,22460,2330,140,129,109,80,72,64,58,53,48,46,48,59,
     78,102,128,153,176,199,222,248,276,299,314,321,326,332,341,357,378,401,
     425,447,467,485,506,531,558,586,616,649,686,731,788,858,934,1020,1127,
     1256,1402,1557,1712,1864,2012,2158,2312,2473,2628,2774,2916,3055,3206,
     3385,3597,3829,4056,4273,4499,4751,5039,5372,5727,6067,6344,6559,6751,
     6969,7219,7548,7981,8554,9249,9986,10551,10827,11115,11548,12166,13105,
     14336,15660,16950,18290,19666,21079,22554,23274,23944,24563,25135,25662,
     26146,26590,26996,27367,27706,28014,28295,28550,28782,2036,119,105,78,54,
     52,44,38,33,29,27,27,30,36,44,53,61,69,78,87,97,107,115,119,120,120,121,
     125,134,146,161,176,191,204,215,227,243,262,285,312,342,374,406,438,473,
     510,552,606,671,744,820,895,974,1059,1152,1257,1367,1465,1542,1604,1658,
     1725,1821,1954,2114,2274,2427,2592,2780,2999,3258,3537,3804,4018,4180,
     4317,4475,4678,4974,5386,5945,6605,7251,7653,7733,7777,7986,8397,9116,
     10103,11212,12378,13681,15115,16660,18279,19170,20022,20825,21577,22279,
     22930,23534,24091,24605,25077,25510,25907,26269,26600)
    temp3 <- c(
     2418,144,130,109,81,74,65,59,54,49,47,50,60,80,105,132,157,182,206,230,
     259,289,314,330,337,341,348,358,374,397,423,449,474,497,519,544,573,603,
     634,665,698,736,783,842,916,997,1087,1197,1330,1479,1637,1794,1949,2099,
     2248,2407,2572,2731,2880,3023,3163,3316,3497,3713,3948,4179,4400,4630,
     4888,5182,5525,5893,6250,6548,6784,7003,7251,7531,7885,8340,8938,9664,
     10438,11042,11354,11618,12018,12594,13488,14669,15930,17143,18413,19733,
     21105,22554,23274,23944,24563,25135,25662,26146,26590,26996,27367,27706,
     28014,28295,28550,28782,2107,124,110,80,54,53,45,38,33,29,28,28,31,37,46,
     54,63,71,80,90,101,111,119,123,124,124,125,129,138,153,170,187,204,217,
     230,242,258,279,305,335,368,402,436,469,504,540,583,637,705,783,861,939,
     1020,1107,1201,1308,1419,1519,1598,1663,1721,1792,1892,2028,2189,2349,
     2503,2671,2868,3100,3377,3676,3963,4190,4359,4500,4664,4873,5181,5610,
     6196,6893,7586,8027,8127,8147,8331,8705,9372,10297,11335,12438,13700,
     15118,16661,18279,19170,20022,20825,21577,22279,22930,23534,24091,24605,
     25077,25510,25907,26269,26600)

    temp3 <- -log(1- c(temp1,temp2, temp2[1:220], temp3)/100000)/365.24

    # Add in the extrapolated data for 1990 and 2000
    temp <- array(0, c(110,2, 4, 3))
    temp[,,1:2,] <- temp3
    fix  <- c(.00061*(0:109) - .1271, .00041*(0:109) - .1770,
	       rep(c(-.00015*(0:109) - .0979, .00050*(0:109) - .1448), 2))
    temp[,,3,]   <- exp(log(temp[,,2,]) + fix)
    temp[,,4,]   <- exp(log(temp[,,3,]) + fix)

    attributes(temp) <- list (
	dim      =c(110,2,4,3),
	dimnames =list(0:109, c("male", "female"), 10* 197:200,
			      c("white", "nonwhite", "black")),
	dimid    =c("age", "sex", "year", "race"),
	factor   =c(0,1,10,1),
	cutpoints=list(0:109 * 365.24, NULL, mdy.date(1,1, 197:200*10), NULL),
	summary = function(R) {
		     x <- c(format(round(min(R[,1]) /365.24, 1)),
			    format(round(max(R[,1]) /355.24, 1)),
			    sum(R[,2]==1), sum(R[,2]==2),
			    sum(R[,4]==1), sum(R[,4]==2), sum(R[,4]==3))
		     x2<- as.character(as.date(c(min(R[,3]), max(R[,3]))))

		     paste("  age ranges from", x[1], "to", x[2], "years\n",
			   " male:", x[3], " female:", x[4], "\n",
			   " date of entry from", x2[1], "to", x2[2], "\n",
			   " white:",x[7], " nonwhite:", x[8]," black:", x[9],
			   "\n")
		     },
	class='ratetable')
    temp
    }
