#
#  rmutil : A Library of Special Functions for Repeated Measurements
#  Copyright (C) 1998 J.K. Lindsey
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#  DESCRIPTION
#
#    Utility functions for printing repeated measurements results

residuals.gnlr <- function(z) z$residuals
fitted.values.gnlr <- function(z) z$fitted.values
coefficients.gnlr <- function(z) z$coefficients
weights.gnlr <- function(z) z$prior.weights
df.residual.gnlr <- function(z) z$df
deviance.gnlr <- function(z) 2*z$maxlike

print.gnlr <- function(z) {
	sht <- z$nps>0
	mix <- z$npm>0
	gnlmm <- !is.null(z$points)
	censor <- if(mix)!is.null(z$censor) else z$censor
	npl <- z$npl-gnlmm
	np1 <- z$npl+1
	np1a <- z$npl+z$npm+1
	np2 <- z$npl+z$npm+z$nps
	np3 <- np2+1
	np <- z$npl+z$npm+z$nps+z$npf
	cat("\nCall:\n",deparse(z$call),"\n\n",sep="")
	if(z$code>2)cat("Warning: no convergence - error",z$code,"\n\n")
	if(mix&&censor)cat(z$censor,"")
	if(censor)cat("censored ")
	if(z$npf>0&(z$dist=="inverse Gauss"|z$dist=="logistic"|z$dist=="gamma"|z$dist=="Weibull"|z$dist=="extreme value"))
		cat("generalized ")
	cat(z$dist,"distribution\n\n")
	if(gnlmm){
		cat(" with normal mixing distribution on",z$scale,"scale\n")
		cat(" (",z$points," point Gauss-Hermite integration)\n\n",sep="")}
	t <- deparse(z$likefn)
	cat("Log likelihood function:",t[2:length(t)],"",sep="\n")
	t <- deparse(z$mu)
	cat("Location function:",t[2:length(t)],sep="\n")
	if(is.language(z$linear[[1]]))
		cat("Linear part: ",deparse(z$linear[[1]]),"\n")
	if(mix){
		t <- deparse(z$mix)
		cat("\nMixture function:",t[2:length(t)],sep="\n")
		if(is.language(z$linear[[2]]))
			cat("Linear part: ",deparse(z$linear[[2]]),"\n")}
	if(sht){
		if(!mix){
			t <- deparse(z$shape)
			cat("\nLog shape function:",t[2:length(t)],sep="\n")
			if(is.language(z$linear[[2]]))
				cat("Linear part: ",deparse(z$linear[[2]]),"\n")}
		if(!is.null(z$family)){
			t <- deparse(z$family)
			cat("\n(Log) family function:",t[2:length(t)],sep="\n")
			if(is.language(z$linear[[3]]))
				cat("Linear part: ",deparse(z$linear[[3]]),"\n")}}
	cat("\n-Log likelihood   ",z$maxlike,"\n")
	cat("Degrees of freedom",z$df,"\n")
	cat("AIC               ",z$aic,"\n")
	cat("Iterations        ",z$iterations,"\n\n")
	if(npl>0){
		cat("Location parameters:\n")
		coef.table <- cbind(z$coefficients[1:npl],z$se[1:npl])
		dimnames(coef.table) <- list(z$cname, c("estimate", "se"))
		print.default(coef.table,digits=4,print.gap=2)}
	if(z$npm>0){
		cat("\nMixture parameters:\n")
		coef.table <- cbind(z$coefficients[np1:(np-sht)],z$se[np1:(np-sht)])
		dimnames(coef.table) <- list(z$mname, c("estimate", "se"))
		print.default(coef.table,digits=4,print.gap=2)}
	if(gnlmm){
		cat("\nMixing standard deviation:\n")
		coef.table <- cbind(z$coefficients[z$npl],z$se[z$npl])
		dimnames(coef.table) <- list("p1", c("estimate", "se"))
		print.default(coef.table, digits=4, print.gap=2)}
	if(z$nps>0){
		cat("\nShape parameters:\n")
		coef.table <- cbind(z$coefficients[np1a:np2],z$se[np1a:np2])
		dimnames(coef.table) <- list(z$sname, c("estimate", "se"))
		print.default(coef.table,digits=4,print.gap=2)}
	if(z$npf>0){
		cat("\nFamily parameters:\n")
		coef.table <- cbind(z$coefficients[np3:np],z$se[np3:np])
		dimnames(coef.table) <- list(z$fname, c("estimate", "se"))
		print.default(coef.table, digits=4, print.gap=2)}
	if(np>1){
		cat("\nCorrelations:\n")
		dimnames(z$corr) <- list(seq(1,np),seq(1,np))
		print.default(z$corr, digits=4)}
	invisible(z)}
