\name{gnlr}
\title{Fit a Generalized Nonlinear Regression Model}
\usage{
gnlr(y, dist="normal", pmu=NULL, pshape=NULL, mu=NULL, shape=NULL,
	linear=NULL, exact=F, wt=1, delta=1, shfn=F,
	print.level=0, typsiz=abs(p), ndigit=10, gradtol=0.00001,
	stepmax=10*sqrt(p\%*\%p), steptol=0.00001, iterlim=100, fscale=1)
}
\alias{gnlr}
\alias{coefficients.gnlr}
\alias{deviance.gnlr}
\alias{df.residual.gnlr}
\alias{fitted.values.gnlr}
\alias{residuals.gnlr}
\alias{weights.gnlr}
\arguments{
\item{y}{A response vector for uncensored data or a two column
matrix for binomial data. For censored data, two columns with
the second being the censoring indicator (1: uncensored, 0: right
censored, -1: left censored.) It may also be an object of class,
response.}
\item{dist}{Either a character string containing the name of the
distribution or a function giving the -log likelihood and calling the
location and shape functions.}
\item{pmu}{Vector of initial estimates for the location parameters.}
\item{pshape}{Vector of initial estimates for the shape parameters.}
\item{mu}{User-specified function of \code{pmu}, and possibly \code{linear},
giving the regression equation for the location. This may contain a linear
part as the second argument to the function. It may also be a language
expression beginning with ~, specifying a linear regression function
for the location parameter. If neither is supplied, the location is
taken to be constant unless the linear argument is given.}
\item{shape}{User-specified function of \code{pshape}, and possibly
\code{linear} and/or \code{mu}, giving the regression equation for the
dispersion or shape parameter. This may contain a linear part as the
second argument to the function and the location as last argument (in
which case \code{shfn} must be set to TRUE). It may also be a language
expression beginning with ~, specifying a linear regression function
for the shape parameter. If neither is supplied, this parameter is
taken to be constant unless the linear argument is given. This
parameter is the logarithm of the usual one.}
\item{linear}{Language expression beginning with ~, specifying the
linear part of the regression function for the location parameter
or list of two such expressions for the location and/or shape parameters.}
\item{exact}{If TRUE, fits the exact likelihood function for
continuous data by integration over intervals of observation,
i.e. interval censoring.}
\item{wt}{Weight vector.}
\item{delta}{Scalar or vector giving the unit of measurement (always
one for discrete data) for each response value, set to unity by
default. For example, if a response is measured to two decimals,
delta=0.01. If the response is transformed, this must be multiplied by
the Jacobian. The transformation cannot contain unknown
parameters. For example, with a log transformation,
\code{delta=1/y}. (The delta values for the censored response are
ignored.)}
\item{shfn}{If true, the supplied shape function depends on the
location (function). The name of this location function must be the
last argument of the shape function.}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{gnlr} fits user-specified nonlinear regression equations to one
or both parameters of the common one and two parameter distributions
(binomial, beta binomial, double binomial, Poisson, negative binomial,
double Poisson, gamma count, Consul generalized Poisson, logarithmic
series, geometric, normal, inverse Gauss, logistic, exponential, gamma,
Weibull, extreme value, Cauchy, Pareto, Laplace, and Levy;
all but the binomial and beta binomial may be right and/or left
censored). A user-specified -log likelihood can also be supplied for
the distribution.
}
\value{
A list of class gnlr is returned.
The printed output includes the -log likelihood (not the deviance),
the corresponding AIC, the maximum likelihood estimates, standard
errors, and correlations. A list is returned that contains all of the
relevant information calculated, including error codes.
}
\seealso{
\code{\link{lm}}, \code{\link{fmr}}, \code{\link{glm}}, \code{\link{glmm}},
\code{\link{gnlmm}}, \code{\link{gnlr3}}, \code{\link{fmr},
\code{\link{nlr}}.
}
\examples{
# linear regression with inverse Gauss distribution
mu <- function(p) p[1]+p[2]*sex+p[3]*age
gnlr(data, dist="inverse Gauss", pmu=rep(1,3), psh=1, mu=mu)
# or equivalently
gnlr(data, dist="inverse Gauss", pmu=rep(1,3), psh=1, mu=~sex+age)
# or
gnlr(data, dist="inverse Gauss", pmu=rep(1,3), psh=1,
	linear=~sex+age)
#
# nonlinear regression with inverse Gauss distribution
mu <- function(p, linear) p[4]+exp(linear)
gnlr(data, dist="inverse Gauss", pmu=rep(1,4), psh=1, mu=mu,
	linear=~sex+age)
# one explicit parameter in mu, three in linear, one for shape
#
# include regression for the shape parameter with same mu function
shape <- function(p) p[1]+p[2]*sex+p[3]*age
gnlr(data, dist="inverse Gauss", pmu=rep(1,4), psh=rep(1,3), mu=mu,
	shape=shape)
# or equivalently
gnlr(data, dist="inverse Gauss", pmu=rep(1,4), psh=rep(1,3), mu=mu,
	linear=~sex+age, shape=~sex+age)
# or
gnlr(data, dist="inverse Gauss", p=rep(1,7), mu=mu,
	linear=list(~sex+age,~sex+age))
# shape as a function of the mean
shape <- function(p, mu) p[1]+p[2]*sex+p[3]*mu
gnlr(data, dist="inverse Gauss", pmu=rep(1,4), psh=rep(1,3), mu=mu,
	shape=shape, linear=~sex+age, shfn=T)
}
