\name{gnlr}
\title{Fit an Intensity Function to Event Histories}
\usage{
ehr(point, p=p, lambda=NULL, linear=NULL, wt=1,
print.level=0, typsiz=rep(1,length(p)), ndigit=10, gradtl=0.00001,
stepmx=max(10*sqrt(p\%*\%p),10), steptl=0.0004, itnlim=100, fscale=1)
}
\alias{ehr}
\arguments{
\item{point}{A point process vector produced by \code{\link{pp}}.}
\item{p}{Vector of initial parameter estimates.}
\item{lambda}{User-specified function of \code{p}, and possibly \code{linear},
giving the regression equation for the intensity. It may contain a linear
part that must simply be given the name, \code{linear}, in the function. If
no function is supplied, the intensity is taken to be constant (a
homogeneous Poisson process) unless the linear argument is given.}
\item{linear}{Language expression beginning with ~ specifying the
linear part of the regression function.}
\item{wt}{Weight vector.}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{ehr} fits an intensity function to event histories, where point is
produced by \code{point <- pp(y)} and \code{lambda} is the user-defined
log intensity function.

Lindsey, J.K. (1995) Fitting parametric counting processes by
using log linear models. Journal of the Royal Statistical
Society C44, 201-212.
}
\seealso{
\code{\link{bp}}, \code{\link{ident}}, \code{\link{pp}}, \code{\link{tccov}},
\code{\link{tpast}}, \code{\link{ttime}}, \code{\link{tvcov}}.
}
\examples{
y <- c(5,3,2,4)
p <- pp(y)
ptime <- tpast(y)
i <- c(1,1,2,2)
id <- ident(y, i)
tx <- c(2,3,1,2,2,2,2)
x <- c(1,2,2,1,2,2,1)
zcov <- tvcov(y, x, tx)
# Weibull process
lambda <- function(p) p[1]+p[2]*log(ptime)
ehr(p, p=c(1,1), lambda=lambda)
# time-varying covariate
lambda <- function(p) p[1]+p[2]*zcov
ehr(p, p=c(1,1), lambda=lambda)
}
