\name{poly.from.values}
\title{Lagrange Interpolation Polynomial}
\usage{
poly.from.values(x, px, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{x-values at which the polynomial has been evaluated.
Duplicates are allowed, but see below.}
\item{px}{y-values for the polynomial for which an interpolation polynomial is
required.  If there are duplicate x-values, the corresponding y-values
must also be identical (to within tol) or a warning is issued.
Duplicates are then ignored and the first instance only is used.

If \code{px} is a matrix, the column size must be the same as the length
of \code{x}, and a list of polynomials is returned got by using each
column of \code{px} as a set of y-values in turn.}
\item{tol}{Error tolerance for judging (a) when y-values are close enough to be
regarded as identical, and (b) when calculated coefficients are
sufficiently close to zero in absolute value to allow them to be
removed.}
}
\description{
Given a set of (x,y) points, construct the minimum degree polynomial
passing through them.

The unvarnished Lagrange formula is used, which may present numerical
difficulties on some occasions.
}
\value{
The Lagrange interpolating polynomial.
}
\seealso{
poly.from.zeros, poly
}
\examples{
x <- c(0,1,2,4)
px <- poly(x,3)
poly.from.values(x,px)
## $P1:
## -0.591607978309962 + 0.338061701891407*x 
## $P2:
## 0.564076074817766 - 1.1684432978368*x + 0.282038037408883*x^2 
## $P3:
## -0.286038776773678 + 3.11464445820227*x - 2.50283929676968*x^2 +  
## 0.437003686737563*x^3 
}
