% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pedigree.R
\name{get.pedigree_old}
\alias{get.pedigree_old}
\title{Derive pedigree}
\usage{
get.pedigree_old(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  founder.zero = TRUE,
  raw = FALSE,
  use.id = TRUE,
  id = NULL,
  use.first.copy = FALSE,
  include.error = FALSE,
  depth = 1
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{founder.zero}{Parents of founders are displayed as "0" (default: TRUE)}

\item{raw}{Set to TRUE to not convert numbers into Sex etc.}

\item{use.id}{Set to TRUE to extract individual IDs}

\item{id}{Replaced by use.id ((consistency with all other get.xxx functions))}

\item{use.first.copy}{Set to TRUE to use database-position of the first copy of an individual (default: FALSE)}

\item{include.error}{Set to TRUE to include errors simulated in the pedigree}

\item{depth}{Depth (1) for parents, (2) for grandparents, (3) for grandgrandparents etc.}
}
\value{
Pedigree-file for in gen/database/cohorts selected individuals
}
\description{
Derive pedigree for selected individuals
}
\examples{
data(ex_pop)
get.pedigree_old(ex_pop, gen=2)
}
