% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{fossils.to.paleotree.record}
\alias{fossils.to.paleotree.record}
\title{Transforms a fossils dataframe and either taxonomy or tree into a fossilRecordSimulation object from package paleotree.}
\usage{
fossils.to.paleotree.record(fossils, tree = NULL, taxonomy = NULL)
}
\arguments{
\item{fossils}{fossils object}

\item{tree}{phylo object containing the tree. If provided and taxonomy = NULL, all speciation is assumed symmetric}

\item{taxonomy}{taxonomy object. If both tree and taxonomy are provided, only taxonomy will be used.}
}
\value{
The converted paleotree record
}
\description{
Transforms a fossils dataframe and either taxonomy or tree into a fossilRecordSimulation object from package paleotree.
}
\examples{
# simulate tree
t = ape::rtree(6)
# simulate fossils using taxonomy
s = sim.taxonomy(t, 0.5, 1, 0.5)
f = sim.fossils.poisson(2, taxonomy = s)
# transform format
record = fossils.to.paleotree.record(f, taxonomy = s)
}
\seealso{
\code{\link{taxonomy}}, \code{\link{fossils}}, \code{\link{paleotree.record.to.fossils}}
}
