% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richnessEstimateR.R
\name{richnessEstimateR}
\alias{richnessEstimateR}
\title{Estimate country, continental, and global species richnesses}
\usage{
richnessEstimateR(
  data = NULL,
  sampleSize = 10000,
  countrySamples = 1,
  continentSamples = 1,
  globalSamples = 1,
  countriesToExclude = NULL,
  mc.cores = 1,
  k = 10,
  filterToRecordedCountries = TRUE,
  outPath = tempdir(),
  fileName = "continentSampled.pdf"
)
}
\arguments{
\item{data}{an RData file created using the \code{\link[=richnessPrepR]{richnessPrepR()}} function.}

\item{sampleSize}{Numeric. The size of the sample randomly drawn from the provided curve.
See \code{curveFunction}. Default = 10000.}

\item{countrySamples}{Numeric. The number of times to sample the country species richness for both
iChao and iNEXT. If equal to zero (0), then this will not be analysed. Default = 5.}

\item{continentSamples}{Numeric. The number of times to sample the continent species richness for both
iChao and iNEXT. If equal to zero (0), then this will not be analysed. Default = 5.}

\item{globalSamples}{Numeric. The number of times to sample the global species richness for both
iChao and iNEXT. If equal to zero (0), then this will not be analysed. Default = 5.}

\item{countriesToExclude}{Character vector. You may decide to excluse some countries if they are
being problematic or their sample sizes are too small. Default = NULL.}

\item{mc.cores}{Numeric. If > 1, the function will run in parallel
using mclapply using the number of cores specified. If = 1 then it will be run using a serial
loop. NOTE: Windows machines must use a value of 1 (see ?parallel::mclapply). Additionally,
be aware that each thread can use large chunks of memory.
Default = 1.}

\item{k}{Numeric. For iChao; the cut-off point (default = 10), which separates species into "abundant" and "rare"
groups for abundance data for the estimator ACE; it separates species into "frequent" and
"infrequent" groups for incidence data for the estimator ICE.
Default = 10.}

\item{filterToRecordedCountries}{Logical. If TRUE, the checklist will be filtered to the countries
Where occurrence records were found. Default = TRUE. Change at your own peril.}

\item{outPath}{A directory as character. Directory where to save output figure. Default = tempdir().}

\item{fileName}{A character vector with file name
for the output figure, ending with '.pdf'. Default = "continentSampled.pdf".}
}
\value{
Outputs an R file with four tables ("Summary", "SiteOutput", "ContinentOutput", and
"GlobalOutput"; depending on the number required). The summary table shows the Median overall
estimates, while the remaining three shows the outputs from each iteration (useful for plotting,
see relevant vignette). Some figures may also be saved to the selected outPath.
}
\description{
Takes an output dataset from \code{\link[=richnessPrepR]{richnessPrepR()}} to estimate species richness using
iChao and iNEXT (hill numbers) for countries, continents, and/or the entire globe.
}
\examples{
\dontrun{

  # Use the example data 
data(beesCountrySubset)

  # First, 
estimateDataExample <- BeeBDC::richnessPrepR(
  data = beesCountrySubset,
  # Download the taxonomy
  taxonomyFile = BeeBDC::beesTaxonomy(),
  # Download the checklist
  checklistFile = BeeBDC::beesChecklist(),
  curveFunction = function(x) (228.7531 * x * x^-log(12.1593)),
  sampleSize = 10000,
  countryColumn = "country_suggested",
  limitGlobal = NULL,
  outPath = tempdir()
)

 exampleEstimate <- richnessEstimateR(
   data = estimateDataExample,
   sampleSize = 10000,
   countrySamples = 1,
   continentSamples = 1,
   globalSamples = 1,
   filterToRecordedCountries = TRUE,
   mc.cores = 1,
   # Directory where to save files
   outPath = tempdir(),
   fileName = "Sampled.pdf"
 )
 
} # END dontrun

}
\seealso{
\code{\link[=countryHarmoniseR]{countryHarmoniseR()}} to harmonise country names based on a short list;
\code{\link[=richnessPrepR]{richnessPrepR()}} to produce the input data and for the required column names; as well
as \code{\link[=ChaoWrapper]{ChaoWrapper()}} and \code{\link[=iNEXTwrapper]{iNEXTwrapper()}} for the parallelised implementation of
\code{SpadeR} and \code{iNEXT} functions.
}
