% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_fit_functions.R
\name{BCSregcontrol}
\alias{BCSregcontrol}
\alias{BCSreg.control}
\title{Auxiliary for Controlling a Box-Cox Symmetric Fitting}
\usage{
BCSreg.control(
  lambda = NULL,
  method = "BFGS",
  maxit = 2000,
  hessian = FALSE,
  trace = FALSE,
  start = NULL,
  ...
)
}
\arguments{
\item{lambda}{numeric indicating the value of lambda (if \code{NULL}, lambda
will be estimated).}

\item{method}{character specifying the \code{method} argument passed to \code{\link{optim}}.}

\item{maxit, trace, ...}{arguments passed to \code{\link{optim}}.}

\item{hessian}{logical. Should the numerical Hessian matrix from the \code{optim} output be
used for estimation of the covariance matrix. By default the analytical solution is employed.}

\item{start}{an optional vector with starting values for the regression coefficients
associated with the \code{mu} and \code{sigma} submodels (starting value for the
\code{lambda} or the zero-adjustment parameters must not be included).}
}
\value{
A list with components named as the arguments.
}
\description{
Optimization parameters that control the fitting of Box-Cox symmetric or
    zero-adjusted Box-Cox symmetric regression
    models using the \code{\link{BCSreg}} function.
}
\details{
The \code{BCSreg.control} controls the fitting process of Box-Cox symmetric models.
    Almost all the arguments are passed directly to \code{\link{optim}}, which
    is used to estimate the parameters. Starting values for the regression coefficients
    associated with the \code{mu} and \code{sigma} submodels can be provided via \code{start}
    argument. The starting value for the skewness parameter \code{lambda} is zero; that is,
    the fitting process starts from the corresponding log-symmetric regression model. If the
    estimation process is to be performed with a fixed \code{lambda}, a value must be specified
    for the \code{lambda} argument. A natural value is \code{lambda = 0}, where a log-symmetric
    regression model will be estimated.

    When a regression fit with a zero-adjusted BCS distribution is performed, the regression
    coefficients associated with the zero-adjustment parameter are estimated
    using the \code{\link[stats]{glm}} function.
}
\examples{
## Data set: raycatch (for description, run ?raycatch)
hist(raycatch$cpue, xlab = "Catch per unit effort")
plot(cpue ~ tide_phase, raycatch,
     xlab = "Tide phase", ylab = "Catch per unit effort")

### Fit a Box-Cox normal regression model:
fit_bcno <- BCSreg(cpue ~ tide_phase, raycatch)
fit_bcno

### Fit a log-normal regression model (setting lambda = 0):
fit_lno <- BCSreg(cpue ~ tide_phase, raycatch, lambda = 0)
fit_lno

### Standard errors obtained from the numerical Hessian matrix
### provided by optim instead of the analytical solution:
fit_bcno2 <- BCSreg(cpue ~ tide_phase, raycatch, hessian = TRUE)
fit_lno2 <- BCSreg(cpue ~ tide_phase, raycatch, lambda = 0, hessian = TRUE)

# In this case, there are differences only in the eighth decimal place:
vcov(fit_bcno)
vcov(fit_bcno2)

# In this case, there are no differences:
vcov(fit_lno)
vcov(fit_lno2)
}
\seealso{
\code{\link{BCSreg}}
}
\author{
Francisco F. de Queiroz <\email{felipeq@ime.usp.br}>

Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
