/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import java.util.Arrays;
import sample.DiploidStates;
import sample.RecombSingleNodes;
import sample.SamplerData;
import vcf.BasicGL;
import vcf.GL;

public class RecombSingleBaumLevel {
    private static final int INITIAL_CAPACITY = 400;
    private static final float MIN_VALUE = 1.4E-43f;
    private final SamplerData samplerData;
    private final Dag dag;
    private final GL gl;
    private int marker = -1;
    private int sample = -1;
    private int size = 0;
    private int capacity = 400;
    private int[] edges1 = new int[400];
    private int[] edges2 = new int[400];
    private float[] fwdValues = new float[400];
    private float[] bwdValues = new float[400];
    private float fwdValueSum = 0.0f;
    private float bwdValueSum = 0.0f;
    private int nGenotypes = 0;
    private float[] gtProbs = new float[3];

    public RecombSingleBaumLevel(SamplerData samplerData) {
        this.samplerData = samplerData;
        this.dag = samplerData.rdag().dag();
        this.gl = samplerData.gl();
    }

    public void setForwardValues(RecombSingleNodes recombSingleNodes, DiploidStates diploidStates, int n, int n2) {
        this.marker = n;
        this.sample = n2;
        this.nGenotypes = this.gl.marker(n).nGenotypes();
        this.size = 0;
        this.fwdValueSum = 0.0f;
        this.bwdValueSum = 0.0f;
        this.initializeGtProbs();
        this.setStates(recombSingleNodes, diploidStates);
        this.setChildNodes(recombSingleNodes);
    }

    private void initializeGtProbs() {
        if (this.gtProbs.length < this.nGenotypes) {
            int n = Math.max(this.nGenotypes, 3 * this.gtProbs.length / 2 + 1);
            this.gtProbs = new float[n];
        } else {
            Arrays.fill(this.gtProbs, 0, this.nGenotypes, 0.0f);
        }
    }

    private void setStates(RecombSingleNodes recombSingleNodes, DiploidStates diploidStates) {
        int n;
        float f = 0.0f;
        diploidStates.setMarker(this.marker);
        while (diploidStates.hasNext()) {
            int n2;
            diploidStates.next();
            n = diploidStates.edge1();
            float f2 = this.fwdValue(n, n2 = diploidStates.edge2(), recombSingleNodes);
            if (!((double)f2 > 0.0)) continue;
            if (this.size == this.capacity) {
                this.ensureCapacity(this.size + 1);
            }
            this.edges1[this.size] = n;
            this.edges2[this.size] = n2;
            this.fwdValues[this.size++] = f2;
            f += f2;
        }
        if (f <= 0.0f) {
            throw new IllegalStateException(String.valueOf(f));
        }
        n = 0;
        while (n < this.size) {
            int n3 = n++;
            this.fwdValues[n3] = this.fwdValues[n3] / f;
        }
        this.fwdValueSum = f;
    }

    private float fwdValue(int n, int n2, RecombSingleNodes recombSingleNodes) {
        int n3;
        float f = 0.0f;
        int n4 = this.dag.symbol(this.marker, n);
        float f2 = this.gl.gl(this.marker, this.sample, n4, n3 = this.dag.symbol(this.marker, n2));
        if ((double)f2 > 0.0) {
            float f3 = this.samplerData.pRecomb(this.marker);
            float f4 = (1.0f - f3) * (1.0f - f3);
            float f5 = f3 * (1.0f - f3);
            float f6 = f3 * f3;
            float f7 = this.dag.condEdgeProb(this.marker, n);
            float f8 = this.dag.condEdgeProb(this.marker, n2);
            float f9 = f7 * f8;
            int n5 = this.dag.parentNode(this.marker, n);
            int n6 = this.dag.parentNode(this.marker, n2);
            float f10 = this.dag.parentProb(this.marker, n5);
            float f11 = this.dag.parentProb(this.marker, n6);
            f = f4 * f2 * f9 * recombSingleNodes.value(n5, n6);
            f += f5 * f2 * f9 * f11 * recombSingleNodes.sumNode1Value(n5);
            f += f5 * f2 * f9 * f10 * recombSingleNodes.sumNode2Value(n6);
            if ((f += f6 * f2 * f9 * f10 * f11 * recombSingleNodes.sumValue()) < 1.4E-43f) {
                f = 1.4E-43f;
            }
        }
        return f;
    }

    public void setChildNodes(RecombSingleNodes recombSingleNodes) {
        recombSingleNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edges1[i]);
            int n2 = this.dag.childNode(this.marker, this.edges2[i]);
            recombSingleNodes.sumUpdate(n, n2, this.fwdValues[i]);
        }
    }

    public void setInitialBackwardValues(RecombSingleNodes recombSingleNodes) {
        float f = 1.0f / (float)this.size;
        this.bwdValueSum = this.size;
        recombSingleNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n;
            this.bwdValues[i] = f;
            int n2 = n = BasicGL.genotype(this.symbol1(i), this.symbol2(i));
            this.gtProbs[n2] = this.gtProbs[n2] + this.fwdValues[i];
            float f2 = this.nextBaseBwdValue(this.edges1[i], this.edges2[i], this.bwdValues[i]);
            int n3 = this.dag.parentNode(this.marker, this.edges1[i]);
            int n4 = this.dag.parentNode(this.marker, this.edges2[i]);
            recombSingleNodes.sumUpdate(n3, n4, f2);
        }
    }

    public void setBackwardValues(RecombSingleNodes recombSingleNodes) {
        float f;
        int n;
        for (int i = 0; i < this.size; ++i) {
            n = this.dag.childNode(this.marker, this.edges1[i]);
            int n2 = this.dag.childNode(this.marker, this.edges2[i]);
            float f2 = this.dag.parentProb(this.marker + 1, n);
            f = this.dag.parentProb(this.marker + 1, n2);
            float f3 = this.samplerData.pRecomb(this.marker + 1);
            float f4 = (1.0f - f3) * (1.0f - f3);
            float f5 = f3 * (1.0f - f3);
            float f6 = f3 * f3;
            float f7 = f4 * recombSingleNodes.value(n, n2) / (f2 * f);
            f7 += f5 * recombSingleNodes.sumNode1Value(n) / f2;
            f7 += f5 * recombSingleNodes.sumNode2Value(n2) / f;
            this.bwdValues[i] = f7 += f6 * recombSingleNodes.sumValue();
            this.bwdValueSum += f7;
        }
        recombSingleNodes.clear();
        float f8 = 0.0f;
        for (n = 0; n < this.size; ++n) {
            int n3;
            int n4 = n;
            this.bwdValues[n4] = this.bwdValues[n4] / this.bwdValueSum;
            float f9 = this.fwdValues[n] * this.bwdValues[n];
            int n5 = n3 = BasicGL.genotype(this.symbol1(n), this.symbol2(n));
            this.gtProbs[n5] = this.gtProbs[n5] + f9;
            f8 += f9;
            f = this.nextBaseBwdValue(this.edges1[n], this.edges2[n], this.bwdValues[n]);
            if (!(f > 0.0f)) continue;
            int n6 = this.dag.parentNode(this.marker, this.edges1[n]);
            int n7 = this.dag.parentNode(this.marker, this.edges2[n]);
            recombSingleNodes.sumUpdate(n6, n7, f);
        }
        n = 0;
        while (n < this.nGenotypes) {
            int n8 = n++;
            this.gtProbs[n8] = this.gtProbs[n8] / f8;
        }
    }

    private float nextBaseBwdValue(int n, int n2, float f) {
        int n3;
        float f2 = this.dag.edgeProb(this.marker, n);
        float f3 = this.dag.edgeProb(this.marker, n2);
        int n4 = this.dag.symbol(this.marker, n);
        float f4 = this.gl.gl(this.marker, this.sample, n4, n3 = this.dag.symbol(this.marker, n2));
        float f5 = f4 * f * f2 * f3;
        if (f5 < 1.4E-43f && (double)f > 0.0) {
            f5 = 1.4E-43f;
        }
        return f5;
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public int marker() {
        return this.marker;
    }

    public int nGenotypes() {
        return this.nGenotypes;
    }

    public float gprobs(int n) {
        if (n >= this.nGenotypes) {
            String string = "gt=" + n + " >= nGenotypes()=" + this.nGenotypes;
            throw new IllegalArgumentException(string);
        }
        return this.gtProbs[n];
    }

    public int capacity() {
        return this.edges1.length;
    }

    public void reset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.size = 0;
        this.capacity = n;
        this.edges1 = new int[n];
        this.edges2 = new int[n];
        this.fwdValues = new float[n];
        this.bwdValues = new float[n];
    }

    public int size() {
        return this.size;
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            String string = "state=" + n + " size()=" + this.size();
            throw new IndexOutOfBoundsException(string);
        }
    }

    public int edge1(int n) {
        this.checkIndex(n);
        return this.edges1[n];
    }

    public int edge2(int n) {
        this.checkIndex(n);
        return this.edges2[n];
    }

    public int parentNode1(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edges1[n]);
    }

    public int parentNode2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edges2[n]);
    }

    public int childNode1(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edges1[n]);
    }

    public int childNode2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edges2[n]);
    }

    public int symbol1(int n) {
        return this.dag.symbol(this.marker, this.edge1(n));
    }

    public int symbol2(int n) {
        return this.dag.symbol(this.marker, this.edge2(n));
    }

    public float forwardValue(int n) {
        this.checkIndex(n);
        return this.fwdValues[n];
    }

    public float backwardValue(int n) {
        this.checkIndex(n);
        return this.bwdValues[n];
    }

    public float forwardValuesSum() {
        return this.fwdValueSum;
    }

    public float backwardValuesSum() {
        return this.bwdValueSum;
    }

    public String toString() {
        String string = " ";
        String string2 = " | ";
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("level=");
        stringBuilder.append(this.marker);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" forwardValuesSum=");
        stringBuilder.append(this.fwdValueSum);
        stringBuilder.append(" backwardSum=");
        stringBuilder.append(this.bwdValueSum);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("j=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.edge1(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edge2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.forwardValue(i));
            stringBuilder.append(string);
            stringBuilder.append(this.backwardValue(i));
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
            if (this.capacity < n) {
                this.capacity = n;
            }
            this.edges1 = Arrays.copyOf(this.edges1, this.capacity);
            this.edges2 = Arrays.copyOf(this.edges2, this.capacity);
            this.fwdValues = Arrays.copyOf(this.fwdValues, this.capacity);
            this.bwdValues = Arrays.copyOf(this.bwdValues, this.capacity);
        }
    }
}

