## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ShiVa)
library(phylolm)


## -----------------------------------------------------------------------------
data('flowerTree')
data('flowerSize')

## -----------------------------------------------------------------------------
Y = flowerSize$log_transformed_size
names(Y) = rownames(flowerSize)
tree = flowerTree
# normalize the tree
tree$edge.length = flowerTree$edge.length/max(node.depth.edgelength(flowerTree))

## -----------------------------------------------------------------------------
set.seed(111)
result = ShiVa(Y,tree, lambda.type = "lambda.min")


## ----fig.height=8,fig.width=8-------------------------------------------------
plot(result$best_model,title = "ShiVa")

## -----------------------------------------------------------------------------
print(summary(result$best_model))

