/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets.analysis;

import java.util.HashMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;

public class MovingProcessingFacade<T> {
    private final Function<TsDomain, T> processing;
    private final HashMap<TsDomain, T> m_cache = new HashMap();
    private final TsDomain m_domainT;
    private static final int NYEARS = 8;
    private int m_increment;
    private int m_length;
    private TsPeriod m_start;

    public MovingProcessingFacade(TsDomain domain, Function<TsDomain, T> processing) {
        this.processing = processing;
        this.m_domainT = domain;
        this.m_cache.put(this.m_domainT, processing.apply(this.m_domainT));
        this.m_start = this.m_domainT.get(0);
        this.m_increment = this.m_domainT.getAnnualFrequency();
        this.m_length = this.m_increment * 8;
    }

    public double getData(TsDomain domain, ToDoubleFunction<T> extractor) {
        T info = this.tsInfo(domain);
        if (info == null) {
            return Double.NaN;
        }
        return extractor.applyAsDouble(info);
    }

    public TsDomain getDomain() {
        return this.m_domainT;
    }

    public int getIncrement() {
        return this.m_increment;
    }

    public void setIncrement(int m_increment) {
        this.m_increment = m_increment;
    }

    public int getLength() {
        return this.m_length;
    }

    public void setLength(int m_length) {
        this.m_length = m_length;
    }

    public TsPeriod getStart() {
        return this.m_start;
    }

    public void setStart(TsPeriod m_start) {
        this.m_start = m_start;
    }

    public Function<TsDomain, T> getProcessing() {
        return this.processing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T tsInfo(TsDomain domain) {
        HashMap<TsDomain, T> hashMap = this.m_cache;
        synchronized (hashMap) {
            T it = this.m_cache.get(domain);
            if (it == null && !this.m_cache.containsKey(domain)) {
                try {
                    it = this.processing.apply(domain);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_cache.put(domain, it);
            }
            return it;
        }
    }
}

