/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;

public class QRDecomposition {
    private final FastMatrix qr;
    private final double[] beta;
    private final int[] pivot;

    public QRDecomposition(FastMatrix qr, double[] beta, int[] pivot) {
        this.qr = qr;
        this.beta = beta;
        this.pivot = pivot;
    }

    public void applyQ(double[] b) {
        double[] p = this.qr.getStorage();
        int m = this.qr.getRowsCount();
        int n = this.qr.getColumnsCount();
        if (m != b.length) {
            throw new MatrixException("m_err_dim");
        }
        int k = n - 1;
        int ik = (m + 1) * (n - 1);
        while (k >= 0) {
            if (this.beta[k] != 0.0) {
                double s = b[k] / this.beta[k];
                int i = k + 1;
                int j = ik + 1;
                while (i < m) {
                    s += p[j] * b[i];
                    ++i;
                    ++j;
                }
                if (s != 0.0) {
                    int n2 = k;
                    b[n2] = b[n2] - s;
                    s *= -this.beta[k];
                    i = k + 1;
                    j = ik + 1;
                    while (i < m) {
                        int n3 = i++;
                        b[n3] = b[n3] + s * p[j];
                        ++j;
                    }
                }
            }
            --k;
            ik -= m + 1;
        }
    }

    public void applyQt(double[] b) {
        double[] p = this.qr.getStorage();
        int m = this.qr.getRowsCount();
        int n = this.qr.getColumnsCount();
        if (m != b.length) {
            throw new MatrixException("m_err_dim");
        }
        int k = 0;
        int ik = 0;
        while (k < n) {
            if (this.beta[k] != 0.0) {
                double s = b[k] / this.beta[k];
                int i = k + 1;
                int j = ik + 1;
                while (i < m) {
                    s += b[i] * p[j];
                    ++i;
                    ++j;
                }
                if (s != 0.0) {
                    int n2 = k;
                    b[n2] = b[n2] - s;
                    s *= -this.beta[k];
                    i = k + 1;
                    j = ik + 1;
                    while (i < m) {
                        int n3 = i++;
                        b[n3] = b[n3] + s * p[j];
                        ++j;
                    }
                }
            }
            ++k;
            ik += m + 1;
        }
    }

    public int m() {
        return this.qr.getRowsCount();
    }

    public int n() {
        return this.qr.getColumnsCount();
    }

    public FastMatrix rawR() {
        int n = this.qr.getColumnsCount();
        FastMatrix R = this.qr.extract(0, n, 0, n).deepClone();
        UpperTriangularMatrix.toUpper(R);
        return R;
    }

    public int[] pivot() {
        return this.pivot == null ? null : (int[])this.pivot.clone();
    }

    public DoubleSeq rawRdiagonal() {
        return this.qr.diagonal();
    }

    public int pivotSign() {
        if (this.pivot == null) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.pivot.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.pivot[j] <= this.pivot[i]) continue;
                ++n;
            }
        }
        return n % 2 == 0 ? 1 : -1;
    }

    @FunctionalInterface
    public static interface Decomposer {
        public QRDecomposition decompose(FastMatrix var1);
    }
}

