/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixStorage;

public class MatrixResults {
    MatrixStorage data_;
    int start_;

    public void clear() {
        this.data_ = null;
    }

    public int getCurrentSize() {
        return this.data_.getCurrentSize();
    }

    public int getDim() {
        return this.data_.getMatrixColumnsCount();
    }

    public void prepare(int dim, int start, int end) {
        this.clear();
        this.start_ = start;
        this.data_ = new MatrixStorage(dim, end - start);
    }

    public void prepare(int nrows, int ncols, int start, int end) {
        this.clear();
        this.start_ = start;
        this.data_ = new MatrixStorage(nrows, ncols, end - start);
    }

    public FastMatrix matrix(int t) {
        if (this.data_ == null || t < this.start_) {
            return null;
        }
        return this.data_.matrix(t - this.start_);
    }

    public DataBlock item(int row, int col) {
        return this.data_.item(row, col);
    }

    public void save(int t, FastMatrix P) {
        int st = t - this.start_;
        if (st < 0) {
            return;
        }
        int capacity = this.data_.getCapacity();
        if (capacity <= st) {
            this.data_.resize(capacity << 1);
        }
        this.data_.save(st, P);
    }

    public int getStartSaving() {
        return this.start_;
    }

    public void rescale(double factor) {
        this.data_.rescale(factor);
    }
}

