/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;

public class HouseholderR {
    private double[] qrauxilary;
    private FastMatrix matrix;
    private int[] pivot;
    private int nrows;
    private int ncols;
    private int rank;
    private double eps = Constants.getEpsilon();

    public void decompose(FastMatrix m) {
        this.init(m.deepClone());
        this.householder();
    }

    public int[] getPivot() {
        return this.pivot;
    }

    public int getRank() {
        return this.rank;
    }

    private void init(FastMatrix m) {
        this.matrix = m;
        this.nrows = m.getRowsCount();
        this.ncols = m.getColumnsCount();
        this.pivot = new int[this.ncols];
        for (int i = 0; i < this.ncols; ++i) {
            this.pivot[i] = i;
        }
        this.qrauxilary = new double[this.ncols];
    }

    private void householder() {
        double[] tmp1 = new double[this.ncols];
        double[] tmp2 = new double[this.ncols];
        double[] x = this.matrix.getStorage();
        DataBlockIterator columns = this.matrix.columnsIterator();
        for (int i = 0; i < this.ncols; ++i) {
            double nrm;
            this.qrauxilary[i] = nrm = columns.next().norm2();
            tmp1[i] = nrm;
            tmp2[i] = nrm == 0.0 ? 1.0 : nrm;
        }
        int lup = Math.min(this.nrows, this.ncols);
        this.rank = this.ncols;
        double eps = this.getPrecision();
        int l = 0;
        int lq = 0;
        while (l < lup) {
            int nl;
            double nrmxl;
            while (l < this.rank && this.qrauxilary[l] < tmp2[l] * eps) {
                int z = this.ncols - 1;
                System.arraycopy(x, (l + 1) * this.nrows, x, l * this.nrows, (z - l) * this.nrows);
                int ip = this.pivot[l];
                double aux = this.qrauxilary[l];
                double t1 = tmp1[l];
                double t2 = tmp2[l];
                for (int k = l; k < z; ++k) {
                    this.qrauxilary[k] = this.qrauxilary[k + 1];
                    tmp1[k] = tmp1[k + 1];
                    tmp2[k] = tmp2[k + 1];
                    this.pivot[k] = this.pivot[k + 1];
                }
                this.qrauxilary[z] = aux;
                tmp1[z] = t1;
                tmp2[z] = t2;
                this.pivot[z] = ip;
                --this.rank;
            }
            if (l != this.nrows - 1 && (nrmxl = DataBlock.of(x, lq, lq + (nl = this.nrows - l)).norm2()) != 0.0) {
                double xq = x[lq];
                if (xq < 0.0) {
                    nrmxl = -nrmxl;
                }
                int j = lq;
                while (j < lq + nl) {
                    int n = j++;
                    x[n] = x[n] / nrmxl;
                }
                int n = lq;
                x[n] = x[n] + 1.0;
                j = l + 1;
                int jc = lq + this.nrows;
                while (j < this.ncols) {
                    double t = 0.0;
                    int k = 0;
                    int iq = lq;
                    int jq = jc;
                    while (k < nl) {
                        t -= x[iq] * x[jq];
                        ++k;
                        ++iq;
                        ++jq;
                    }
                    t /= x[lq];
                    k = 0;
                    iq = lq;
                    jq = jc;
                    while (k < nl) {
                        int n2 = jq++;
                        x[n2] = x[n2] + t * x[iq];
                        ++k;
                        ++iq;
                    }
                    if (this.qrauxilary[j] != 0.0) {
                        double z = x[jc] / this.qrauxilary[j];
                        double tt = Math.max(0.0, 1.0 - z * z);
                        if (tt < 1.0E-6) {
                            this.qrauxilary[j] = DataBlock.of(x, jc + 1, jc + nl).norm2();
                            tmp1[j] = this.qrauxilary[j];
                        } else {
                            int n3 = j;
                            this.qrauxilary[n3] = this.qrauxilary[n3] * Math.sqrt(tt);
                        }
                    }
                    ++j;
                    jc += this.nrows;
                }
                this.qrauxilary[l] = x[lq];
                x[lq] = -nrmxl;
            }
            ++l;
            lq += this.nrows + 1;
        }
        this.rank = Math.min(this.rank, this.nrows);
    }

    public double getPrecision() {
        return this.eps;
    }

    public void setPrecision(double eps) {
        this.eps = eps;
    }

    private void pivot(double[] external, double[] internal) {
        for (int i = 0; i < external.length; ++i) {
            internal[i] = external[this.pivot[i]];
        }
    }

    private void restore(double[] external, double[] internal) {
        for (int i = 0; i < external.length; ++i) {
            external[this.pivot[i]] = internal[i];
        }
    }

    public void applyQt(double[] b) {
        this.applyQt(b, this.rank);
    }

    public void applyQt(double[] b, int k) {
        double[] x = this.matrix.getStorage();
        int kmax = Math.min(k, this.nrows - 1);
        int j = 0;
        int jj = 0;
        while (j < kmax) {
            if (this.qrauxilary[j] != 0.0) {
                double a = this.qrauxilary[j];
                double t = -a * b[j];
                int i = j + 1;
                int l = jj + 1;
                while (i < this.nrows) {
                    t -= x[l] * b[i];
                    ++i;
                    ++l;
                }
                int n = j;
                b[n] = b[n] + (t /= a) * a;
                i = j + 1;
                l = jj + 1;
                while (i < this.nrows) {
                    int n2 = i++;
                    b[n2] = b[n2] + t * x[l];
                    ++l;
                }
            }
            ++j;
            jj += this.nrows + 1;
        }
    }

    public void applyQ(double[] b) {
        this.applyQ(b, this.rank);
    }

    public void applyQ(double[] xb, int k) {
        int j;
        double[] b = (double[])xb.clone();
        this.pivot(xb, b);
        double[] x = this.matrix.getStorage();
        int kmax = Math.min(k, this.nrows - 1);
        int jj = j * (this.nrows + 1);
        for (j = kmax - 1; j >= 0; --j) {
            if (this.qrauxilary[j] != 0.0) {
                double a = this.qrauxilary[j];
                double t = -a * b[j];
                int i = j + 1;
                int l = jj + 1;
                while (i < this.nrows) {
                    t -= x[l] * b[i];
                    ++i;
                    ++l;
                }
                int n = j;
                b[n] = b[n] + (t /= a) * a;
                i = j + 1;
                l = jj + 1;
                while (i < this.nrows) {
                    int n2 = i++;
                    b[n2] = b[n2] + t * x[l];
                    ++l;
                }
            }
            jj -= this.nrows + 1;
        }
        this.restore(xb, b);
    }

    public double[] solve(double[] x) {
        if (this.rank != Math.min(this.nrows, this.ncols)) {
            throw new MatrixException("m_err_sing");
        }
        double[] b = new double[this.rank];
        this.leastSquares((DoubleSeq)DataBlock.of(x), DataBlock.of(b), null);
        return b;
    }

    public void partialLeastSquares(DoubleSeq x, DataBlock b, DataBlock res) throws MatrixException {
        double[] data = this.matrix.getStorage();
        double[] y = x.toArray();
        int rc = b.length();
        this.applyQt(y, rc);
        if (res != null) {
            res.copyFrom(y, rc);
        }
        int k = rc - 1;
        int kk = k * (this.nrows + 1);
        while (k >= 0) {
            int n = k;
            y[n] = y[n] / data[kk];
            for (int i = 0; i < k; ++i) {
                int n2 = i;
                y[n2] = y[n2] - y[k] * data[i + k * this.nrows];
            }
            --k;
            kk -= this.nrows + 1;
        }
        b.copyFrom(y, 0);
    }

    public int rank(int nvars) {
        int rank = this.getRank();
        if (nvars < 0 || nvars >= this.pivot.length) {
            return rank;
        }
        int n = 0;
        for (int i = 0; i < nvars; ++i) {
            if (this.pivot[i] >= rank) continue;
            ++n;
        }
        return n;
    }

    public FastMatrix r() {
        double[] x = this.matrix.getStorage();
        int rank = this.getRank();
        FastMatrix r = FastMatrix.square(rank);
        double[] data = r.getStorage();
        int i = 0;
        int k = 0;
        int l = 0;
        while (i < rank) {
            for (int j = 0; j <= i; ++j) {
                data[k + j] = x[l + j];
            }
            ++i;
            k += rank;
            l += this.nrows;
        }
        return r;
    }

    public int getRowsCount() {
        return this.nrows;
    }

    public int getColumnsCount() {
        return this.ncols;
    }

    public DoubleSeq rdiagonal() {
        return this.matrix.diagonal();
    }

    public int rank() {
        return this.rank;
    }

    public int[] unused() {
        int[] n = new int[this.ncols - this.rank];
        int i = this.rank;
        int j = 0;
        while (i < this.ncols) {
            n[j] = this.pivot[i];
            ++i;
            ++j;
        }
        return n;
    }

    public void leastSquares(DoubleSeq x, DataBlock b, DataBlock res) throws MatrixException {
        double[] data = this.matrix.getStorage();
        double[] y = new double[x.length()];
        x.copyTo(y, 0);
        this.applyQt(y, this.rank);
        if (res != null) {
            res.copyFrom(y, this.rank);
        }
        double epsc = this.eps * 1000.0;
        int k = this.rank - 1;
        int kk = k * (this.nrows + 1);
        while (k >= 0) {
            double xkk = data[kk];
            if (Math.abs(xkk) > epsc) {
                int n = k;
                y[n] = y[n] / xkk;
                for (i = 0; i < k; ++i) {
                    int n2 = i;
                    y[n2] = y[n2] - y[k] * data[i + k * this.nrows];
                }
            } else {
                for (i = 0; i < k; ++i) {
                    double xcur = data[i + k * this.nrows];
                    if (!(Math.abs(xcur) > epsc)) continue;
                    throw new MatrixException("m_err_rank");
                }
            }
            --k;
            kk -= this.nrows + 1;
        }
        b.copyFrom(y, 0);
    }
}

