/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math;

public interface ComplexType {
    public double getRe();

    public double getIm();

    public static double abs(double re, double im) {
        if (re == 0.0 && im == 0.0) {
            return 0.0;
        }
        double absX = Math.abs(re);
        double absY = Math.abs(im);
        double w = Math.max(absX, absY);
        double z = Math.min(absX, absY);
        if (z == 0.0) {
            return w;
        }
        double zw = z / w;
        return w * Math.sqrt(1.0 + zw * zw);
    }

    default public double abs() {
        return ComplexType.abs(this.getRe(), this.getIm());
    }

    public static double arg(double re, double im) {
        return Math.atan2(im, re);
    }

    default public double arg() {
        return ComplexType.arg(this.getRe(), this.getIm());
    }
}

