/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.utility;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import lombok.Generated;

public final class CompactSsf {
    public static ISsf compact(ISsf ssf) {
        if (!ssf.measurement().hasError()) {
            return ssf;
        }
        return Ssf.of(new Initialization(ssf), new Dynamics(ssf), new Loading(ssf));
    }

    @Generated
    private CompactSsf() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Initialization
    implements ISsfInitialization {
        private final ISsfInitialization initialization;

        Initialization(ISsf ssf) {
            this.initialization = ssf.initialization();
        }

        @Override
        public int getStateDim() {
            return this.initialization.getStateDim() + 1;
        }

        @Override
        public boolean isDiffuse() {
            return this.initialization.isDiffuse();
        }

        @Override
        public int getDiffuseDim() {
            return this.initialization.getStateDim();
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            this.initialization.diffuseConstraints(b.dropTopLeft(1, 0));
        }

        @Override
        public void a0(DataBlock a0) {
            this.initialization.a0(a0.drop(1, 0));
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            this.initialization.Pf0(pf0.dropTopLeft(1, 1));
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            this.initialization.Pi0(pi0.dropTopLeft(1, 1));
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final ISsfDynamics dynamics;
        private final ISsfError error;
        private final double e;

        Dynamics(ISsf ssf) {
            this.dynamics = ssf.dynamics();
            this.error = ssf.measurementError();
            this.e = this.error.isTimeInvariant() ? Math.sqrt(this.error.at(0)) : 0.0;
        }

        private double err(int pos) {
            return this.e != 0.0 ? this.e : Math.sqrt(this.error.at(pos));
        }

        @Override
        public int getInnovationsDim() {
            return this.dynamics.getInnovationsDim() + 1;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return this.dynamics.areInnovationsTimeInvariant() && this.e != 0.0;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            this.dynamics.V(pos, qm.dropTopLeft(1, 1));
            qm.set(0, 0, this.error.at(pos));
        }

        @Override
        public void S(int pos, FastMatrix s) {
            this.dynamics.S(pos, s.dropTopLeft(1, 1));
            s.set(0, 0, this.err(pos));
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.e != 0.0 || this.dynamics.hasInnovations(pos) || this.error.at(pos) > 0.0;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            this.dynamics.T(pos, tr.dropTopLeft(1, 1));
        }

        @Override
        public void TX(int pos, DataBlock x) {
            this.dynamics.TX(pos, x.drop(1, 0));
            x.set(0, 0.0);
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            this.dynamics.TVT(pos, vm.dropTopLeft(1, 1));
            vm.row(0).set(0.0);
            vm.column(0).set(0.0);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            this.dynamics.addSU(pos, x.drop(1, 0), u.drop(1, 0));
            x.add(0, u.get(0) * this.err(pos));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            this.dynamics.addV(pos, p.dropTopLeft(1, 1));
            p.add(0, 0, this.error.at(pos));
        }

        @Override
        public void XT(int pos, DataBlock x) {
            this.dynamics.XT(pos, x.drop(1, 0));
            x.set(0, 0.0);
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            this.dynamics.XS(pos, x.drop(1, 0), xs.drop(1, 0));
            xs.set(0, x.get(0) * this.err(pos));
        }

        @Override
        public boolean isTimeInvariant() {
            return this.dynamics.isTimeInvariant() && this.error.isTimeInvariant();
        }
    }

    static class Loading
    implements ISsfLoading {
        private final ISsfLoading loading;

        Loading(ISsf s) {
            this.loading = s.loading();
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.set(0, 1.0);
            this.loading.Z(pos, z.drop(1, 0));
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            double r = x.get(0);
            return r + this.loading.ZX(pos, x.drop(1, 0));
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            zm.copy(m.row(0));
            FastMatrix q = m.dropTopLeft(1, 0);
            DataBlockIterator cols = q.columnsIterator();
            DoubleSeqCursor.OnMutable cur = zm.cursor();
            while (cols.hasNext()) {
                cur.applyAndNext(x -> x + this.loading.ZX(pos, cols.next()));
            }
        }

        @Override
        public double ZVZ(int pos, FastMatrix vm) {
            double r = vm.get(0, 0);
            r += 2.0 * this.loading.ZX(pos, vm.row(0).drop(1, 0));
            return r += this.loading.ZVZ(pos, vm.dropTopLeft(1, 1));
        }

        @Override
        public void VpZdZ(int pos, FastMatrix vm, double d) {
            this.loading.VpZdZ(pos, vm.dropTopLeft(1, 1), d);
            vm.add(0, 0, d);
            this.loading.XpZd(pos, vm.column(0).drop(1, 0), d);
            this.loading.XpZd(pos, vm.row(0).drop(1, 0), d);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            this.loading.XpZd(pos, x.drop(1, 0), d);
            x.add(0, d);
        }

        @Override
        public boolean isTimeInvariant() {
            return this.loading.isTimeInvariant();
        }
    }
}

