/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;

public interface ISsfData
extends DoubleSeq {
    public boolean isMissing(int var1);

    default public boolean isConstraint(int pos) {
        return false;
    }

    default public int getObsCount() {
        int nm = 0;
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            if (!this.isMissing(i)) continue;
            ++nm;
        }
        return n - nm;
    }

    default public boolean hasMissingValues() {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            if (!this.isMissing(i)) continue;
            return true;
        }
        return false;
    }

    default public double scale() {
        int n = this.length();
        int nd = 0;
        double sabs = 0.0;
        DoubleSeqCursor cursor = this.cursor();
        for (int i = 0; i < n; ++i) {
            double c = cursor.getAndNext();
            if (Double.isFinite(c)) {
                sabs += Math.abs(c);
                continue;
            }
            ++nd;
        }
        if (nd == n) {
            return 0.0;
        }
        return sabs / (double)(n - nd);
    }
}

