/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.interpolation.DataInterpolator;
import jdplus.toolkit.base.core.data.transformation.LogJacobian;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderWithPivoting;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaFixedMapping;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping2;
import jdplus.toolkit.base.core.stats.likelihood.LogLikelihoodFunction;
import jdplus.toolkit.base.core.timeseries.simplets.Transformations;
import jdplus.toolkit.base.core.timeseries.simplets.TsDataTransformation;
import lombok.NonNull;

public final class ModelDescription {
    private final TsData series;
    private final TsDomain estimationDomain;
    private double[] interpolatedData;
    private double[] transformedData;
    private double llCorrection;
    private int[] missing = IntList.EMPTY;
    private boolean logTransformation;
    private LengthOfPeriodType lpTransformation = LengthOfPeriodType.None;
    private boolean mean;
    private final List<Variable> variables = new ArrayList<Variable>();
    private SarimaSpec arima = SarimaSpec.whiteNoise();
    private boolean sortedVariables;
    public static final Comparator<Variable> OUTLIER_COMPARATOR = (o1, o2) -> {
        IOutlier c1 = (IOutlier)o1.getCore();
        IOutlier c2 = (IOutlier)o2.getCore();
        return c1.getPosition().compareTo(c2.getPosition());
    };
    private static final String EXCLUDED = "excluded variable: ";
    private static final String COLLINEAR = "collinear model. Some coefficients are set to 0";
    private static final String NOTFOUND = ": data not found";
    private static final String ZERO = ": is zero";

    public static ModelDescription dummyModel() {
        return new ModelDescription();
    }

    public static ModelDescription copyOf(@NonNull ModelDescription model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return ModelDescription.copyOf(model, model.estimationDomain);
    }

    public static ModelDescription copyOf(@NonNull ModelDescription model, TsDomain estimationDomain) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        ModelDescription nmodel = new ModelDescription(model.series, estimationDomain);
        nmodel.arima = model.arima;
        nmodel.mean = model.mean;
        nmodel.logTransformation = model.logTransformation;
        nmodel.lpTransformation = model.lpTransformation;
        nmodel.interpolatedData = model.interpolatedData;
        nmodel.transformedData = model.transformedData;
        nmodel.missing = model.missing;
        nmodel.llCorrection = model.llCorrection;
        model.variables.forEach(nmodel.variables::add);
        return nmodel;
    }

    private ModelDescription() {
        this.series = null;
        this.estimationDomain = null;
    }

    public ModelDescription(@NonNull TsData series, TsDomain estimationDomain) {
        if (series == null) {
            throw new NullPointerException("series is marked non-null but is null");
        }
        this.series = series;
        if (estimationDomain != null) {
            estimationDomain = estimationDomain.intersection(series.getDomain());
            int beg = series.getStart().until(estimationDomain.getStartPeriod());
            if (series.getValues().range(0, beg).anyMatch(z -> !Double.isFinite(z))) {
                throw new TsException("Missing values outside the estimation domain");
            }
            int end = series.getStart().until(estimationDomain.getEndPeriod());
            if (series.getValues().range(end, series.length()).anyMatch(z -> !Double.isFinite(z))) {
                throw new TsException("Missing values outside the estimation domain");
            }
            this.estimationDomain = estimationDomain;
        } else {
            this.estimationDomain = null;
        }
    }

    private void sortVariables() {
        if (this.sortedVariables) {
            return;
        }
        ArrayList vars = new ArrayList();
        this.variables.stream().filter(v -> v.getCore() instanceof TrendConstant).forEach(v -> vars.add(v));
        this.variables.stream().filter(v -> ModellingUtility.isUser((Variable)v)).forEachOrdered(v -> vars.add(v));
        this.variables.stream().filter(v -> ModellingUtility.isDaysRelated((Variable)v)).forEachOrdered(v -> vars.add(v));
        this.variables.stream().filter(v -> ModellingUtility.isMovingHoliday((Variable)v)).forEachOrdered(v -> vars.add(v));
        this.variables.stream().filter(v -> ModellingUtility.isOutlier((Variable)v)).filter(v -> !ModellingUtility.isAutomaticallyIdentified((Variable)v)).sorted(OUTLIER_COMPARATOR).forEachOrdered(v -> vars.add(v));
        this.variables.stream().filter(v -> ModellingUtility.isOutlier((Variable)v)).filter(v -> ModellingUtility.isAutomaticallyIdentified((Variable)v)).sorted(OUTLIER_COMPARATOR).forEachOrdered(v -> vars.add(v));
        this.variables.clear();
        this.variables.addAll(vars);
        this.sortedVariables = true;
    }

    private void buildTransformation() {
        if (this.transformedData == null) {
            TsData tmp;
            int end;
            int start;
            int diff = this.arima.getDifferencingOrder();
            if (this.estimationDomain == null) {
                start = diff;
                end = this.series.length();
            } else {
                int del = this.series.getStart().until(this.estimationDomain.getStartPeriod());
                start = del + diff;
                end = del + this.estimationDomain.getLength();
            }
            LogJacobian lj = new LogJacobian(start, end, this.missing);
            TsData tsData = tmp = this.interpolatedData == null ? this.series : TsData.ofInternal((TsPeriod)this.series.getStart(), (double[])this.interpolatedData);
            if (this.logTransformation) {
                if (this.lpTransformation != LengthOfPeriodType.None) {
                    tmp = Transformations.lengthOfPeriod(this.lpTransformation).transform(tmp, lj);
                }
                tmp = Transformations.log().transform(tmp, lj);
            }
            this.llCorrection = lj.value;
            if (this.hasFixedEffects()) {
                DataBlock ndata = DataBlock.of(tmp.getValues());
                TsDomain domain = tmp.getDomain();
                this.variables.forEach(v -> {
                    if (!v.isFree()) {
                        FastMatrix m = Regression.matrix(domain, v.getCore());
                        DataBlockIterator columns = m.columnsIterator();
                        int cur = 0;
                        while (columns.hasNext()) {
                            Parameter c;
                            DataBlock col = columns.next();
                            if (!(c = v.getCoefficient(cur++)).isFixed()) continue;
                            ndata.addAY(-c.getValue(), col);
                        }
                    }
                });
                tmp = TsData.ofInternal((TsPeriod)domain.getStartPeriod(), (double[])ndata.getStorage());
            }
            this.transformedData = tmp.getValues().toArray();
        }
    }

    public TsDomain getEstimationDomain() {
        return this.estimationDomain == null ? this.series.getDomain() : this.estimationDomain;
    }

    public int[] getMissingInEstimationDomain() {
        if (this.estimationDomain == null || this.missing.length == 0) {
            return this.missing;
        }
        int start = this.series.getStart().until(this.estimationDomain.getStartPeriod());
        if (start == 0) {
            return this.missing;
        }
        int[] nmissing = (int[])this.missing.clone();
        int i = 0;
        while (i < nmissing.length) {
            int n = i++;
            nmissing[n] = nmissing[n] - start;
        }
        return nmissing;
    }

    public RegArimaModel<SarimaModel> regarima() {
        return this.regarima(null);
    }

    public RegArimaModel<SarimaModel> regarima(ProcessingLog log) {
        DoubleSeq yc;
        this.variables.replaceAll(v -> v.exclude(false));
        this.buildTransformation();
        this.sortVariables();
        TsDomain domain = this.getEstimationDomain();
        double[] y = this.transformedData;
        int n = domain.getLength();
        int[] missingc = this.missing;
        if (y.length > n) {
            int pos = this.series.getStart().until(domain.getStartPeriod());
            yc = DoubleSeq.of((double[])y, (int)pos, (int)n);
            if (this.missing.length > 0) {
                missingc = (int[])this.missing.clone();
                int i = 0;
                while (i < missingc.length) {
                    int n2 = i++;
                    missingc[n2] = missingc[n2] - pos;
                }
            }
        } else {
            yc = DoubleSeq.of((double[])y);
        }
        RegArimaModel.Builder builder = RegArimaModel.builder().y(yc).missing(missingc).meanCorrection(this.mean).arima(SarimaModel.builder(this.arima).build());
        ArrayList<Variable> excluded = new ArrayList<Variable>();
        for (Variable v2 : this.variables) {
            if (v2.isPreadjustment()) continue;
            FastMatrix x = Regression.matrix(domain, log, v2.getCore());
            if (x == null || x.isZero(0.0)) {
                excluded.add(v2);
                continue;
            }
            DataBlockIterator columns = x.columnsIterator();
            int ic = 0;
            while (columns.hasNext()) {
                DataBlock col = columns.next();
                if (!v2.getCoefficient(ic++).isFree()) continue;
                builder.addX(col.unmodifiable());
            }
        }
        if (!excluded.isEmpty()) {
            this.variables.replaceAll(v -> v.exclude(excluded.contains(v)));
        }
        return this.check(builder.build(), log);
    }

    public RegArimaModel<SarimaModel> check(RegArimaModel<SarimaModel> reg0, ProcessingLog log) {
        int[] pos;
        FastMatrix x = reg0.differencedModel().getX();
        HouseholderWithPivoting hous = new HouseholderWithPivoting();
        int curx = reg0.getMissingValuesCount();
        if (reg0.isMean()) {
            ++curx;
        }
        int x0 = curx;
        QRDecomposition qr = hous.decompose(x, curx);
        int rank = UpperTriangularMatrix.rank(qr.rawR(), 1.0E-12);
        if (rank == qr.n()) {
            return reg0;
        }
        if (log != null) {
            log.warning(COLLINEAR);
        }
        RegArimaModel.Builder builder = RegArimaModel.builder().y(reg0.getY()).missing(reg0.missing()).meanCorrection(reg0.isMean()).arima(reg0.arima());
        ArrayList<Variable> nvars = new ArrayList<Variable>();
        int[] pivot = qr.pivot();
        int[] nArray = pos = pivot == null ? null : new int[pivot.length];
        if (pivot != null) {
            for (int i = 0; i < pivot.length; ++i) {
                pos[pivot[i]] = i;
            }
        }
        List<DoubleSeq> all = reg0.getX();
        for (Variable v : this.variables) {
            if (!v.isPreadjustment()) {
                int dim = v.dim();
                for (int k = 0; k < dim; ++k) {
                    boolean redundant;
                    if (!v.getCoefficient(k).isFree()) continue;
                    boolean bl = pos == null ? curx >= rank : (redundant = pos[curx] >= rank);
                    if (redundant) {
                        Parameter[] c = v.getCoefficients();
                        c[k] = Parameter.zero();
                        v = v.withCoefficients(c);
                    } else {
                        builder.addX(all.get(curx - x0));
                    }
                    ++curx;
                }
                if (v.isPreadjustment()) {
                    v = v.exclude(true);
                }
            }
            nvars.add(v);
        }
        this.variables.clear();
        this.variables.addAll(nvars);
        return builder.build();
    }

    private void invalidateTransformation() {
        this.transformedData = null;
        this.llCorrection = 0.0;
    }

    public Variable variable(String name) {
        Optional<Variable> search = this.variables.stream().filter(var -> var.getName().equals(name)).findFirst();
        return search.orElse(null);
    }

    public Variable variable(ITsVariable v) {
        Optional<Variable> search = this.variables.stream().filter(var -> var.getCore() == v).findFirst();
        return search.orElse(null);
    }

    public boolean remove(String name) {
        Optional<Variable> search = this.variables.stream().filter(var -> var.getName().equals(name)).findFirst();
        if (search.isPresent()) {
            this.variables.remove(search.orElseThrow());
            return true;
        }
        return false;
    }

    public boolean remove(ITsVariable v) {
        Optional<Variable> search = this.variables.stream().filter(var -> var.getCore() == v).findFirst();
        if (search.isPresent()) {
            this.variables.remove(search.orElseThrow());
            return true;
        }
        return false;
    }

    public Variable addVariable(Variable var) {
        String name = var.getName();
        while (this.contains(name)) {
            name = ITsVariable.nextName((String)name);
        }
        Variable nvar = var.rename(name);
        this.variables.add(nvar);
        this.sortedVariables = false;
        return nvar;
    }

    public boolean contains(String name) {
        return this.variables.stream().anyMatch(var -> var.getName().equals(name));
    }

    public void setLogTransformation(boolean log) {
        if (this.logTransformation == log) {
            return;
        }
        this.logTransformation = log;
        this.invalidateTransformation();
    }

    public boolean isLogTransformation() {
        return this.logTransformation;
    }

    public boolean isAdjusted() {
        return this.logTransformation && this.lpTransformation != LengthOfPeriodType.None;
    }

    public TsData getSeries() {
        return this.series;
    }

    public TsDomain getDomain() {
        return this.series.getDomain();
    }

    public TsData getTransformedSeries() {
        this.buildTransformation();
        return TsData.ofInternal((TsPeriod)this.series.getStart(), (double[])this.transformedData);
    }

    public TsData getTransformedSeries(boolean correctedForMissings) {
        this.buildTransformation();
        if (correctedForMissings || this.missing.length == 0) {
            return TsData.ofInternal((TsPeriod)this.series.getStart(), (double[])this.transformedData);
        }
        double[] data = (double[])this.transformedData.clone();
        for (int i = 0; i < this.missing.length; ++i) {
            data[this.missing[i]] = Double.NaN;
        }
        return TsData.ofInternal((TsPeriod)this.series.getStart(), (double[])data);
    }

    public TsData getInterpolatedSeries() {
        if (this.interpolatedData == null) {
            return this.series;
        }
        return TsData.ofInternal((TsPeriod)this.series.getStart(), (double[])this.interpolatedData);
    }

    public SarimaSpec getArimaSpec() {
        return this.arima;
    }

    public void setArimaSpec(SarimaSpec spec) {
        this.arima = spec;
        if (this.transformedData != null && (this.arima.getD() != spec.getD() || this.arima.getBd() != spec.getBd())) {
            this.transformedData = null;
            this.buildTransformation();
        }
    }

    public SarimaOrders specification() {
        return this.arima.orders();
    }

    public SarimaModel arima() {
        return SarimaModel.builder(this.arima).build();
    }

    public void setSpecification(SarimaOrders spec) {
        if (this.transformedData != null && (this.arima.getD() != spec.getD() || this.arima.getBd() != spec.getBd())) {
            this.transformedData = null;
        }
        this.arima = SarimaSpec.builder().period(spec.getPeriod()).d(spec.getD()).bd(spec.getBd()).p(spec.getP()).q(spec.getQ()).bp(spec.getBp()).bq(spec.getBq()).buildWithoutValidation();
        this.buildTransformation();
    }

    public void setAirline(boolean seas) {
        int period = this.getAnnualFrequency();
        SarimaOrders s = seas ? SarimaOrders.airline((int)period) : SarimaOrders.m011((int)period);
        this.setSpecification(s);
    }

    public boolean isMean() {
        return this.mean;
    }

    public boolean hasFixedEffects() {
        return this.variables.stream().anyMatch(v -> !v.isFree());
    }

    public Stream<Variable> variables() {
        return this.variables.stream();
    }

    public int countRegressors(Predicate<Variable> pred) {
        return this.variables().filter(pred).mapToInt(var -> var.getCore().dim()).sum();
    }

    public void setPreadjustment(LengthOfPeriodType lengthOfPeriodType) {
        if (this.lpTransformation != lengthOfPeriodType) {
            this.lpTransformation = lengthOfPeriodType;
            this.invalidateTransformation();
        }
    }

    public LengthOfPeriodType getPreadjustment() {
        return this.lpTransformation;
    }

    public void interpolate(@NonNull DataInterpolator interpolator) {
        if (interpolator == null) {
            throw new NullPointerException("interpolator is marked non-null but is null");
        }
        if (this.series.getValues().anyMatch(z -> Double.isNaN(z))) {
            IntList lmissing = new IntList();
            this.interpolatedData = interpolator.interpolate(this.series.getValues(), lmissing);
            if (lmissing.isEmpty()) {
                this.missing = IntList.EMPTY;
            } else {
                this.missing = lmissing.toArray();
                Arrays.sort(this.missing);
            }
            this.invalidateTransformation();
        } else {
            this.interpolatedData = null;
            this.missing = IntList.EMPTY;
        }
    }

    public int[] getMissing() {
        return this.missing;
    }

    public void setMean(boolean mean) {
        this.mean = mean;
    }

    public boolean removeVariable(Predicate<Variable> pred) {
        return this.variables.removeIf(pred.and(var -> ModellingUtility.isAutomaticallyIdentified((Variable)var)));
    }

    public int getAnnualFrequency() {
        return this.series.getAnnualFrequency();
    }

    public List<TsDataTransformation> transformations() {
        ArrayList<TsDataTransformation> tr = new ArrayList<TsDataTransformation>();
        if (this.lpTransformation != LengthOfPeriodType.None) {
            tr.add(Transformations.lengthOfPeriod(this.lpTransformation));
        }
        if (this.logTransformation) {
            tr.add(Transformations.log());
        }
        return tr;
    }

    public List<TsDataTransformation> backTransformations() {
        ArrayList<TsDataTransformation> tr = new ArrayList<TsDataTransformation>();
        if (this.logTransformation) {
            tr.add(Transformations.exp());
        }
        if (this.lpTransformation != LengthOfPeriodType.None) {
            tr.add(Transformations.lengthOfPeriod(this.lpTransformation).converse());
        }
        return tr;
    }

    public List<TsDataTransformation> backTransformations(boolean T2, boolean S) {
        ArrayList<TsDataTransformation> tr = new ArrayList<TsDataTransformation>();
        if (this.logTransformation) {
            tr.add(Transformations.exp());
        }
        if (S && this.lpTransformation != LengthOfPeriodType.None) {
            tr.add(Transformations.lengthOfPeriod(this.lpTransformation).converse());
        }
        return tr;
    }

    public int findPosition(ITsVariable variable) {
        this.sortVariables();
        int pos = 0;
        boolean found = false;
        for (Variable var : this.variables) {
            if (var.isPreadjustment()) continue;
            if (var.getCore() == variable) {
                found = true;
                break;
            }
            pos += var.freeCoefficientsCount();
        }
        if (!found) {
            return -1;
        }
        return this.mean ? pos + 1 : pos;
    }

    public IArimaMapping<SarimaModel> mapping() {
        if (this.arima.hasFixedParameters()) {
            int n = this.arima.getP() + this.arima.getBp() + this.arima.getQ() + this.arima.getBq();
            double[] p = new double[n];
            boolean[] b = new boolean[n];
            int j = 0;
            Parameter[] P = this.arima.getPhi();
            int i = 0;
            while (i < P.length) {
                p[j] = P[i].getValue();
                b[j] = P[i].isFixed();
                ++i;
                ++j;
            }
            P = this.arima.getBphi();
            i = 0;
            while (i < P.length) {
                p[j] = P[i].getValue();
                b[j] = P[i].isFixed();
                ++i;
                ++j;
            }
            P = this.arima.getTheta();
            i = 0;
            while (i < P.length) {
                p[j] = P[i].getValue();
                b[j] = P[i].isFixed();
                ++i;
                ++j;
            }
            P = this.arima.getBtheta();
            i = 0;
            while (i < P.length) {
                p[j] = P[i].getValue();
                b[j] = P[i].isFixed();
                ++i;
                ++j;
            }
            return new SarimaFixedMapping(this.specification(), DoubleSeq.of((double[])p), b);
        }
        return SarimaMapping2.of(this.specification());
    }

    public RegArimaEstimation<SarimaModel> estimate(IRegArimaComputer<SarimaModel> processor) {
        RegArimaModel<SarimaModel> model = this.regarima(null);
        RegArimaEstimation<SarimaModel> rslt = !this.arima.hasFixedParameters() ? processor.process(model, this.mapping()) : processor.optimize(model, this.mapping());
        LogLikelihoodFunction.Point max = rslt.getMax();
        if (max != null) {
            this.setFreeParameters(max.getParameters());
        }
        return RegArimaEstimation.builder().model(rslt.getModel()).concentratedLikelihood(rslt.getConcentratedLikelihood()).max(max).llAdjustment(this.llCorrection).build();
    }

    public void freeArimaParameters() {
        this.arima = this.arima.resetParameters(this.arima);
    }

    public void setFreeParameters(DoubleSeq p) {
        int i;
        SarimaSpec.Builder builder = this.arima.toBuilder();
        DoubleSeqCursor pcur = p.cursor();
        Parameter[] P = this.arima.getPhi();
        for (i = 0; i < P.length; ++i) {
            if (P[i].isFixed()) continue;
            P[i] = Parameter.estimated((double)pcur.getAndNext());
        }
        builder.phi(P);
        P = this.arima.getBphi();
        for (i = 0; i < P.length; ++i) {
            if (P[i].isFixed()) continue;
            P[i] = Parameter.estimated((double)pcur.getAndNext());
        }
        builder.bphi(P);
        P = this.arima.getTheta();
        for (i = 0; i < P.length; ++i) {
            if (P[i].isFixed()) continue;
            P[i] = Parameter.estimated((double)pcur.getAndNext());
        }
        builder.theta(P);
        P = this.arima.getBtheta();
        for (i = 0; i < P.length; ++i) {
            if (P[i].isFixed()) continue;
            P[i] = Parameter.estimated((double)pcur.getAndNext());
        }
        builder.btheta(P);
        this.arima = builder.buildWithoutValidation();
    }
}

